/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WwnComparable
implements Comparable<WwnComparable> {
    private static final Logger logger = LoggerFactory.getLogger(WwnComparable.class);
    private final String wwn;
    private short[] wwnHex;
    private Boolean isStandardFormat = null;
    private static final int HEX_RADIX = 16;
    private static final int WWN_LENGTH = 8;

    public WwnComparable(String wwn) {
        this.wwn = wwn;
    }

    @Override
    public int compareTo(WwnComparable o) {
        short[] hex = this.getWwnHex();
        short[] oHex = o.getWwnHex();
        if (hex == null) {
            if (oHex == null) {
                return 0;
            }
            return -1;
        }
        if (oHex == null) {
            return 1;
        }
        int compareLength = Math.min(hex.length, oHex.length);
        for (int i = 0; i < compareLength; ++i) {
            int diff = hex[i] - oHex[i];
            if (diff == 0) continue;
            return diff;
        }
        return hex.length - oHex.length;
    }

    public short[] getWwnHex() {
        this.maybeInitWwnHex();
        return this.wwnHex;
    }

    public boolean isStandardFormat() {
        this.maybeInitWwnHex();
        return this.isStandardFormat;
    }

    private void maybeInitWwnHex() {
        if (this.wwnHex == null && this.isStandardFormat == null) {
            String[] hexStrings = this.wwn.split(":");
            int length = hexStrings.length;
            if (length != 8) {
                logger.warn("WWN format not recognized \"" + this.wwn + "\"");
            }
            try {
                short[] newWwnHex = new short[length];
                for (int i = 0; i < length; ++i) {
                    newWwnHex[i] = Short.parseShort(hexStrings[i], 16);
                }
                this.wwnHex = newWwnHex;
                this.isStandardFormat = Boolean.TRUE;
            }
            catch (NumberFormatException e) {
                this.isStandardFormat = Boolean.FALSE;
            }
        }
    }

    public String toString() {
        return this.wwn;
    }
}

