/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;


/**
 * Interface for vmware services.
 * 
 * @author slaplante, dhetti
 */
public interface IVMWareService {
	
    public static final String MSG_NO_COLLECTED_HOST_UUID_ON_VIRTUAL_CENTER = "Collected uuid is null or empty for host {0}. " +
        "This host is not available for collection on Virtual Center {1}.";
    
    public static final String MSG_NO_COLLECTED_HOST_UUID = "Collected uuid is null or empty for host {0}. " +
        "This host is not available for collection the Virtual Center.";
    
    public static final String MSG_INVALID_HOST_UUID = "Invalid uuid {0} was collected for host {1}. " +
        "This host will not available for collection from Virtual Center {2}.";
    
    /** ffffffff-ffff-ffff-ffff-ffffffffffff */
    public static final String INVALID_UUID_ALL_F = "ffffffff-ffff-ffff-ffff-ffffffffffff";
    
    /** Invalid Login information URL {0} user {1}. */
    public static final String MSG_INVALID_LOGIN = "Invalid Login information URL {0} user {1}";
    
    /** Error getting sample period for host.*/
    public static final String MSG_ERROR_GETTING_CURRENT_TIME = "Error retrieving current time from connection. {0}";
    
    /** Error retrieving MORs statistics.*/
    public static final String MSG_ERROR_RETRIEVING_MANAGED_OBJECTS_PROPS = "Error retrieving managed Objetcs and properties."
    	+ "Exception Message {0}.";
    
    /** Bad Request URL {0} user {1}. */
    public static final String MSG_ERROR_BAD_REQUEST = "Bad Request URL {0} user {1}";

    /** Connection error happened URL: {0}, user: {1}, cause: {2}, dump: {3}. */
    public static final String MSG_CONNECTION_ERROR = "Connection error happened URL: {0}, user: {1}, cause: {2}, dump: {3}";

    /** VMWare API Type is {0}, which is not VirtualCenter. */
    public static final String MSG_UNSUPPORTED_VMWARE_API_TYPE = "VMWare API Type is {0}, which is not VirtualCenter";

    /** VMWare Product Line Id is {0}, which is not vpx. */
    public static final String MSG_UNSUPPORTED_VMWARE_PRODUCT_LINE = "VMWare Product Line Id is {0}, which is not vpx";		
    
    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_SERVER_LUN_STATS = 
        "Failed to retrieve Server LUN statistics. " +
        "The performance query returned null for Managed Object of Host System: {0}.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_HOST_DS_STATS = 
        "Failed to retrieve Host Datastore statistics. " +
        "The performance query returned null for Managed Object of Host System: {0}.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_VM_DS_STATS = 
        "Failed to retrieve VM Datastore statistics. " +
        "The performance query returned null for Managed Object of Host System: {0}.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_VM_VIRTUALDISK_STATS = 
        "Failed to retrieve VM virtualDisk statistics. " +
        "The performance query returned null for Managed Object of Host System: {0}.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_HOST_ETHERNET_PORT_STATS = 
        "Failed to retrieve Host Ethernet port statistics. " +
        "The performance query returned null for Managed Object of Host System: {0}. " +
        "This ESX host does not contain any ethernet port statistics for the specified time period, " +
        "which is most likely due to a recent server restart. The next statistics collection will result in success.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_VM_LUN_STATS = 
        "Failed to retrieve Virtual Machine storage (LUN) statistics for host {0}. " +
        "The performance query returned null. All Virtual Macahine LUN statistics are NULL.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_HOST_SERVER_STATS = 
        "Failed to retrieve Host Server statistics. " +
        "The performance query returned null for Managed Object: {0} of type: {1}. " +
        "This ESX host does not contain any server statistics for the specified time period, " +
        "which is most likely due to a recent server restart. The next statistics collection will result in success.";
   
    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_ERROR_PERF_QUERY_RETURNED_NULL_FOR_VM_STATS = 
        "Failed to retrieve VM statistics. " +
        "The performance query returned null." ;
    
    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_WARN_VM_STAT_NOT_COLLECTED = 
        "Failed to retrieve Virtual Machine statistics. " +
        "The result did not contain statistics for VM Managed Object: {0} of type: {1} in host {2}.";

    /** Exception while retrieving managed objects and properties. */
    public static final String MSG_WARN_DATASTORE_FOLDER_SEARCH_RESULT_NULL = "Datastore folder information " +
    		"search results incomplete. Need to wait until search tasks are complete. Host : {0}";

    /** Performance query contains stale LUN statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_LUN = 
        "The performance query result contains a stale \"{0}\" statistic for host LUN: {1} on host: {2}. Timestamp: {3}.";

    /** Performance query contains stale host Datastore statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_HOST_DATASTORE = 
        "The performance query result contains a stale \"{0}\" statistic for host datastore: {1} on host: {2}. Timestamp: {3}.";

    /** Performance query contains stale VM Datastore statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_VM_DATASTORE = 
        "The performance query result contains a stale \"{0}\" statistic for VM datastore: {1} on VM: {2}. Timestamp: {3}.";

    /** Performance query contains stale VM virtual disk statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_VM_VIRTUALDISK = 
        "The performance query result contains a stale \"{0}\" statistic for VM virtual disk: {1} on VM: {2}. Timestamp: {3}.";

    /** Performance query contains stale Ethernet port statistics for host. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_HOST_ETHERNET_PORT = 
        "The performance query result contains a stale \"{0}\" statistic for Ethernet port: {1} on host: {2}. " +
        "Timestamp: {3}.";

    /** Performance query skipped, not scsi LUNs present that contain statistics. */
    public static final String MSG_PERF_QUERY_SKIPPED_NO_LUNS_WITH_STATS = "The performance query is being skipped on host: {0}, due to no LUNs with statistics.";

    /** Cannot calculate IO-weighted average LUN latency statistics. */
    public static final String MSG_CANNOT_CALCULATE_IO_WEIGHTED_AVG_LATENCY_STATS_FOR_LUN = 
        "Cannot calculate IO-weighted average latency statistics due to zero read/write IO statistics " +
        "for host LUN: {0} on host: {1}.";

    /** Skipping samples due to one or more negative sample values during latency calculation . */
    public static final String MSG_SKIPPING_LATENCY_SAMPLES_DUE_TO_NEGATIVE_VALUES = 
        "Skipping the following samples for host LUN: {0} on host: {1} due to one or more negative sample values. " +
        "{2} Latency: {3}. Read IOs: {4}. Write IOs: {5}.";

    /** Ignoring negative latency statistics. */
    public static final String MSG_IGNORING_NEGATIVE_LATENCY_STATISTIC_FOR_LUN = 
        "Ignoring negative {0} statistic: {1} for host LUN: {2} on host: {3}.";

    /** Performance Counter ID - SYS_UPTIME_LATEST. */
    public static final String SYS_UPTIME_LATEST = "sys.uptime.latest";
    
    /** Performance Counter ID -  MEM_USAGE_AVERAGE.*/
    public static final String MEM_USAGE_AVERAGE = "mem.usage.average";
    
    /** Performance Counter ID -  MEM_SWAPOUT_AVERAGE.*/
    public static final String MEM_SWAPOUT_AVERAGE = "mem.swapout.average";
    
    /** Performance Counter ID -  MEM_SWAPIN_AVERAGE.*/
    public static final String MEM_SWAPIN_AVERAGE = "mem.swapin.average";
    
    /** Performance Counter ID -  CPU_USAGE_AVERAGE.*/
    public static final String CPU_USAGE_AVERAGE = "cpu.usage.average";
    
    /** Performance Counter ID -  DISK_NUMBERREAD_SUMMATION.*/
    public static final String DISK_NUMBERREAD_SUMMATION = "disk.numberRead.summation";
    
    /** Performance Counter ID -  DISK_NUMBERWRITE_SUMMATION.*/
    public static final String DISK_NUMBERWRITE_SUMMATION = "disk.numberWrite.summation";
    
    /** Performance Counter ID -  DISK_READ_AVERAGE.*/
    public static final String DISK_READ_AVERAGE = "disk.read.average";
    
    /** Performance Counter ID -  DISK_WRITE_AVERAGE.*/
    public static final String DISK_WRITE_AVERAGE = "disk.write.average";
    
    /** Performance Counter ID -  CPU_USAGEMHZ_AVERAGE.*/
    public static final String CPU_USAGEMHZ_AVERAGE = "cpu.usagemhz.average";
    
    /** Performance Counter ID -  CPU_READY_SUMMATION.*/
    public static final String CPU_READY_SUMMATION = "cpu.ready.summation";
    
    /** Performance Counter ID -  DISK_DEVICELATENCY_AVERAGE.*/
    public static final String DISK_DEVICELATENCY_AVERAGE = "disk.deviceLatency.average";
    
    /** Performance Counter ID -  DISK_QUEUELATENCY_AVERAGE.*/
    public static final String DISK_QUEUELATENCY_AVERAGE = "disk.queueLatency.average";
    
    /** Performance Counter ID -  DISK_TOTALLATENCY_AVERAGE.*/
    public static final String DISK_TOTALLATENCY_AVERAGE = "disk.totalLatency.average";

    /** Performance Counter ID -  MEM_CONSUMED_AVERAGE.*/
    public static final String MEM_CONSUMED_AVERAGE = "mem.consumed.average";
    
    /** Performance Counter ID -  MEM_OVERHEAD_AVERAGE.*/
    public static final String MEM_OVERHEAD_AVERAGE = "mem.overhead.average";
    
    /** Performance Counter ID -  MEM_VMMEMCTL_AVERAGE.*/
    public static final String MEM_VMMEMCTL_AVERAGE = "mem.vmmemctl.average";
    
    /** Performance Counter ID -  MEM_VMMEMCTLTARGET_AVERAGE.*/
    public static final String MEM_VMMEMCTLTARGET_AVERAGE = "mem.vmmemctltarget.average";

    /** Performance Counter ID - NET_TRANSMITTED_AVERAGE. */
    public static final String NET_TRANSMITTED_AVERAGE = "net.transmitted.average";

    /** Performance Counter ID - NET_RECEIVED_AVERAGE. */
    public static final String NET_RECEIVED_AVERAGE = "net.received.average";

    /** Performance Counter ID - NET_PACKETSTX_SUMMATION. */
    public static final String NET_PACKETSTX_SUMMATION = "net.packetsTx.summation";

    /** Performance Counter ID - NET_PACKETSRX_SUMMATION. */
    public static final String NET_PACKETSRX_SUMMATION = "net.packetsRx.summation";

    /** Performance Counter ID - NET_USAGE_AVERAGE. */
    public static final String NET_USAGE_AVERAGE = "net.usage.average";
    
    /** Performance Counter ID - DATASTORE_NUMBERREADAVERAGED_AVERAGE. */
    public static final String DATASTORE_NUMBERREADAVERAGED_AVERAGE = "datastore.numberReadAveraged.average";

    /** Performance Counter ID - DATASTORE_NUMBERWRITEAVERAGED_AVERAGE. */
    public static final String DATASTORE_NUMBERWRITEAVERAGED_AVERAGE = "datastore.numberWriteAveraged.average";

    /** Performance Counter ID - DATASTORE_READ_AVERAGE. */
    public static final String DATASTORE_READ_AVERAGE = "datastore.read.average";

    /** Performance Counter ID - DATASTORE_WRITE_AVERAGE. */
    public static final String DATASTORE_WRITE_AVERAGE = "datastore.write.average";

    /** Performance Counter ID - DATASTORE_TOTALREADLATENCY_AVERAGE. */
    public static final String DATASTORE_TOTALREADLATENCY_AVERAGE = "datastore.totalReadLatency.average";

    /** Performance Counter ID - DATASTORE_TOTALWRITELATENCY_AVERAGE. */
    public static final String DATASTORE_TOTALWRITELATENCY_AVERAGE = "datastore.totalWriteLatency.average";

    /** Performance Counter ID -  VIRTUALDISK_NUMBERREAD_AVERAGE.*/
    public static final String VIRTUALDISK_NUMBERREADAVERAGED_AVERAGE = "virtualDisk.numberReadAveraged.average";
    
    /** Performance Counter ID -  VIRTUALDISK_NUMBERWRITE_AVERAGE.*/
    public static final String VIRTUALDISK_NUMBERWRITEAVERAGED_AVERAGE = "virtualDisk.numberWriteAveraged.average";
    
    /** Performance Counter ID -  VIRTUALDISK_READ_AVERAGE.*/
    public static final String VIRTUALDISK_READ_AVERAGE = "virtualDisk.read.average";
    
    /** Performance Counter ID -  VIRTUALDISK_WRITE_AVERAGE.*/
    public static final String VIRTUALDISK_WRITE_AVERAGE = "virtualDisk.write.average";
    
    /** Performance Counter ID - VIRTUALDISK_TOTALREADLATENCY_AVERAGE. */
    public static final String VIRTUALDISK_TOTALREADLATENCY_AVERAGE = "virtualDisk.totalReadLatency.average";

    /** Performance Counter ID - VIRTUALDISK_TOTALWRITELATENCY_AVERAGE. */
    public static final String VIRTUALDISK_TOTALWRITELATENCY_AVERAGE = "virtualDisk.totalWriteLatency.average";

    /** Read timeout setting in milliseconds. 30 min. */
    public static final int READ_TIMEOUT_MILLISECONDS = 1800000;

    /** Host header of raw stats file. */    
    public static final String RAW_FILE_HOST_HEADER = "Host:";

    /** VM header of raw stats file. */    
    public static final String RAW_FILE_VM_HEADER = "VM:";

    /** Resource header of raw stats file. */    
    public static final String RAW_FILE_RESOURCE_HEADER = "Resource:";

    /** Type header of raw stats file. */    
    public static final String RAW_FILE_TYPE_HEADER = "Type:";

    /** Stat name header of raw stats file. */    
    public static final String RAW_FILE_STAT_HEADER = "Stat:";

    /** Timestamp header of raw stats file. */    
    public static final String RAW_FILE_TIME_HEADER = "Ts:";

    /** Stat value header of raw stats file. */    
    public static final String RAW_FILE_VALUE_HEADER = "V:";
    
    /** Resource type string for ESX host of raw stats file. */
    public static final String RAW_FILE_HOST_TYPE = "host";
    
    /** Resource type string for VM of raw stats file. */
    public static final String RAW_FILE_VM_TYPE = "vm";
    
    /** Resource type string for lun of raw stats file. */
    public static final String RAW_FILE_LUN_TYPE = "lun";
    
    /** Resource type string for ethernet port of raw stats file. */
    public static final String RAW_FILE_ETHERNET_PORT_TYPE = "ethernetPort";
    
    /** Resource type string for NAS datastore of raw stats file. */
    public static final String RAW_FILE_NAS_DATASTORE_TYPE = "nasDatastore";
    
    /** Resource type string for virtual disk of raw stats file. */
    public static final String RAW_FILE_VIRTUAL_DISK_TYPE = "virtualDisk";
    
    /** CPU HZ header of raw stats file. */
    public static final String RAW_FILE_CPU_HZ_HEADER = "CpuHz:";
    
    /** Number of CPUs header of raw stats file. */
    public static final String RAW_FILE_NUM_CPUS_HEADER = "NumCpus:";

    /**
     * Obtains the IVMWareContext object which contains a connection to the vmware device.
     * 
     * @param userName user name
     * @param password password
     * @param serviceURL URL to connect
     * @param hostNameOrIp hostNameOrIp to connect
     * @param ignoreCertificate ignore SSL certificate
     * @param deviceType is it a virtual center or ESX //TODO This is not needed since ESX is not required for this project
     * @param accessHandleId id of the access handle of the target device
     * @param timeout read time out setting in milliseconds
     * @return VMware context
     */
    public IVMWareContext connectAndGetContext(String userName, String password, String serviceURL, String hostNameOrIp,
                                               boolean ignoreCertificate, String deviceType, long accessHandleId, int timeout);

    /**
     * close the vCenter connection and destroy the context.
     * @param virtualCenterUrl
     */
    // void disconnect(String virtualCenterUrl);

    /*   *//**
     * Disconnects the given context.
     * @param context IVMWareContext.
     *//*
    public void disconnect(IVMWareContext context);
    
    *//**
     * This method will perform a targeted query of the VMWare API and return information beginning from the given 
     * managed object reference. The given PropertySpec[] will contain what objects and properties to retrieve.
     * 
     * @param context VMWareContext object
     * @param searchMor ManagedObjectReference used to determine where to start the search
     * @param propertySpec property spec containing objects and properties to retrieve
     * @return result ObjectSpec array with all the results from the SOAP API
     *//*
    public Object[] retrieveObjectsAndProperties(IVMWareContext context, Object searchMor, Object[] propertySpec);
    
    *//**
     * This method will query the VMWare API and return all the managed objects and their properties 
     * beginning from the given Managed Object Reference. The Managed Object Reference is the parameter 
     * used to determine where to start the search. The PropertySpec[] will contain what objects and 
     * properties to retrieve.  
     * 
     * @param context VMWareContext object
     * @param searchMor ManagedObjectReference used to determine where to start the search
     * @param traversalSpec traversal spec used to determine what path to search the inventory
     * @return result ObjectSpec array with all the results from the SOAP API
     *//*
    public Object[] retrieveObjectsAndPropertiesVirtualCenterDiscovery(IVMWareContext context, Object searchMor, Object[] traversalSpec);
    
    
    *//**
     * Retrieves Host and Virtual Machine summary for virtual center discovery.
     *
     * @param context IVMWareContext to retrieve the information from
     * @return Data model object for virtual center
     *//*
    public VMWareVirtualCenter queryVirtualCenterSummary(IVMWareContext context);
    
    *//**
     * Retrieves the host's datastore information.
     * 
     * @param context IVMWareContext to retrieve the information from 
     * @param host vmware host collection object
     * @return hostDatastores linked hashmap of host datastores
     *//*
    public LinkedHashMap<Object, VMWareDatastore> retrieveAllPropertiesOfHostDataStores(IVMWareContext context, VMWareHost host);
    
    *//**
     * Retrieves the details of the host and the associated VM's.
     *
     * @param context IVMWareContext to retrieve the information from
     * @param hostMor - VMWareHost object.
     * @return Data model object for host
     *//*
    public VMWareHost queryHostAndVirtualMachineDetailsForDiscovery(IVMWareContext context, Object hostMor);
    
    *//**
     * This method is used to query host stats from the virtual center.
     * 
     * @param context - VMWare context.
     * @param state - State map.
     * @param hostMor - Host managed object reference.
     * @return - VMWare host object.
     *//*
    public VMWareHost queryHostAndVirtualMachineDetailsForStatistics(IVMWareContext context, Map<String, String> state, Object hostMor);
    
    *//**
     * Retrieves all objects and properties for virtual center discovery.
     *
     * @param context IVMWareContext to retrieve the information from
     * @return Data model object for virtual center
     *//*
    public VMWareVirtualCenter queryAllObjectsAndPropertiesVirtualCenterDiscovery(IVMWareContext context);
    
    *//**
     * Retrieves all available virtual machines in a vCenter collection object with a cluster/compute resource hierarchy.
     * 
     * @param context IVMWareContext to retrieve the information from
     * @return vCenter vCenter collection object containing VMs structured in a cluster/compute resource hierarchy
     *//*
    VMWareVirtualCenter retrieveAllVirtualMachines(IVMWareContext context);
    
    *//**
     * Retrieves all objects and properties for host discovery.
     *
     * @param context IVMWareContext to retrieve the information from.
     * @return Data model object for host.
     *//*
    public VMWareHost queryAllObjectsAndPropertiesHostDiscovery(IVMWareContext context);
    
    *//**
     * Retrieves all objects and properties for host statistics.
     *
     * @param context IVMWareContext to retrieve the information from.
     * @param state Collection State Information.
     * @return Data model object for host.
     *//*
    public VMWareHost queryAllObjectsAndPropertiesHostStatistics(IVMWareContext context, Map<String, String> state);
    
    *//**
     * Checks if VC has the correct stats levels set. Need to have level 3 stats enabled for "Past Day".
     * 
     * @param context - VMWareContext.
     * @return - true or false.
     *//*
    public boolean isVirtualCenterStatsLevelSupported(IVMWareContext context);

    *//**
     * Returns the VC version.
     * 
     * @param context - VMWareContext.
     * @return - version string.
     *//*
    public String getVirtualCenterVersion(IVMWareContext context);

    *//**
     * Sets a uuid in the map based on a managed object reference and virtual center instance id.
     * 
     * @param accessHandleId access handle id of the virtual center
     * @param mor managed object reference which is associated to the given uuid
     * @param uuid uuid of the object that is associated with the given managed object reference
     *//*
    public void setUuidInMoRefMap(Long accessHandleId, Object mor, String uuid);
    
    *//**
     * Gets a uuid in the map based on the given managed object reference and virtual center instance id.
     * 
     * @param accessHandleId access handle id of the virtual center
     * @param mor managed object reference which is associated to the given uuid
     * @return uuid uuid of the object that is associated with the given managed object reference
     *//*
    public String getUuidInMoRefMap(Long accessHandleId, Object mor);
    
    *//**
     * Removes the entry in the map with the given virtual center instance id and managed object reference.
     * 
     * @param accessHandleId access handle id of the virtual center
     * @param mor managed object reference which is associated to a uuid
     *//*
    public void removeUuidInMoRefMap(Long accessHandleId, Object mor);
    
    *//**
     * Removes the entry in the map with the given virtual center instance id and the value uuid.
     * * Note: This should be used only when no access to the managed object reference exists.
     * 
     * @param accessHandleId access handle id of the virtual center
     * @param uuidToRemove uuid of object to remove from cache map
     *//*
    public void removeUuidInMoRefMap(Long accessHandleId, String uuidToRemove);
    
    *//**
     * Removes all entries in the map with the given virtual center instance id.
     * 
     * @param accessHandleId access handle id of the virtual center
     *//*
    public void removeAllUuidsInMoRefMap(Long accessHandleId);
    
    *//**
     * Gets the number of hosts managed by the given virtual center.
     * 
     * @param virtualCenter - virtual center managed object reference
     * @return the number of hosts managed by the given virtual center
     *//*
    public int getHostCount(VMWareVirtualCenter virtualCenter);
    
  *//*  *
     * This is a helper method that provides the number of total monitored hosts in the VC.
     * 
     * @param vc VMWareVirtualCenter object.
     * @param vcAccessHandle Virtual Center Access Handle
     * @param context vmware context
     * @return numMonitoredHosts Number of hosts.*//*
    public int getTotalNumberOfMonitoredHostsInVC(VMWareVirtualCenter vc, VirtualCenterAccessHandle vcAccessHandle, IVMWareContext context);

    public List<VMWareVirtualMachine> getUnfilteredVirtualMachines(VMWareVirtualCenter vCenter, VirtualCenterAccessHandle vCenterAccessHandle, IVMWareContext context);

    *//**
     * Returns true if the given cluster should be filtered from the discovery collection.
     *
     * @param cluster vmware cluster collection object.
     * @param vcAccessHandle virtual center access handle
     * @param context vmware context
     * @return true if given cluster should be filtered from discovery collection*//*

    public boolean filterCluster(VMWareCluster cluster, VirtualCenterAccessHandle vcAccessHandle, IVMWareContext context);

   *//* *
     * Returns true if the given host should be filtered from the discovery collection.
     *
     * @param host vmware host collection object
     * @param vcAccessHandle virtual center access handle
     * @return true if the given host should be filtered from the discovery collection*//*

    public boolean filterHost(VMWareHost host, VirtualCenterAccessHandle vcAccessHandle);

   *//* *
     * Given a VMWareVirtualCenter collection object, the configuration information is retrieved and returned.
     *
     * @param vc VMWareVirtualCenter collection object
     * @param virtualCenterAccessHandle virtual center access handle to be created
     * @param context vmware context
     * @return virtualCenterConfigList list of cluster and un-clustered hosts in the virtual center inventory*//*

    public List<IVirtualCenterConfiguration> getInventoryConfiguration(VMWareVirtualCenter vc, VirtualCenterAccessHandle virtualCenterAccessHandle, IVMWareContext context);


    public void setCollectionServer(IConfigStatsDataService collectionServer);*/
}
