/*
 * Copyright (c) 2010 NetApp
 * All rights reserved
 */

package com.netapp.collectors.vmware;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;



import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NasDatastoreInfo;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.VmfsDatastoreInfo;

/**
 * Provides access to VMWare csv raw stat file with the vim25 api, for debugging and unit testing only. Have to put it
 * in src/main/java so that VMWareServiceFactory can access it.
 * 
 * @author simonwu
 */
public class VMWare25CsvService extends VMWare25Service {
    /** Logger. *//*
    private static final Logger logger = Logger.getLogger(VMWare25CsvService.class);

    *//** Instance of the VMWare 25 Service. *//*
    private static VMWare25CsvService vmware25Service;

    private VMWare25CsvStatParser parser = new VMWare25CsvStatParser();

    *//**
     * Default Constructor. Private to avoid direct instantiation.
     *//*
    private VMWare25CsvService() {
        super();
    }

    *//**
     * This creates an instance of the VMWare 25 Service.
     * 
     * @return vmware25Service vmware service instance.
     *//*
    public static VMWare25CsvService getInstance() {
        if (vmware25Service == null) {
            vmware25Service = new VMWare25CsvService();
        }

        return vmware25Service;
    }

    *//** {@inheritDoc} *//*
    public IVMWareContext connectAndGetContext(IAccessHandle accessHandle, boolean ignoreCertificate, String deviceType,
            int timeout) {
        return null;
    }

    *//** {@inheritDoc} *//*
    public IVMWareContext connectAndGetContext(String userName, String password, String serviceURL, boolean ignoreCertificate,
            String deviceType, long accessHandleId, int timeout) {
        parser.setCsvFilename(serviceURL);

        ServiceConnection25 serviceConnection = new ServiceConnection25();
        Calendar now = Calendar.getInstance();
        Calendar fifteenMinAgo = new GregorianCalendar();
        fifteenMinAgo.setTimeInMillis(now.getTimeInMillis() - (15 * 60) * 1000);
        IVMWareContext context = new VMWare25Context(serviceConnection, serviceConnection.getServiceContent(),
                "com.vmware.vim25", false, true, accessHandleId, now, fifteenMinAgo);
        return context;
    }

    *//** {@inheritDoc} *//*
    public void disconnect(IVMWareContext context) {
    }

    *//** {@inheritDoc} *//*
    public VMWareHost queryAllObjectsAndPropertiesHostStatistics(IVMWareContext context, Map<String, String> state) {
        // This is called by ESX stat collector, only 1 host
        ObjectContent[] result = parser.retrieveAllObjectsAndPropertiesHostStatistics();
        ManagedObjectReference hostMor = null;
        for (int i = 0; i < result.length; i++) {
            if (result[i].getObj().getType().equals("HostSystem")) {
                hostMor = result[i].getObj();
                break;
            }
        }
        return processHostStats(context, state, hostMor, result);
    }

    *//**
     * This method will query host datastore IO stats.
     * 
     * @param context - VMWare context object.
     * @param host - host Object.
     *//*
    private void queryHostNasDatastoreStats(IVMWareContext context, VMWareHost host) {
        Set<Object> datastoreMoRefs = host.getAllDataStores().keySet();
        if (datastoreMoRefs == null || datastoreMoRefs.isEmpty()) {
            logger.warn("Host " + host.getName() + " has no datastores, no datastore statistics to process.");
            return;
        }

        LinkedHashMap<Object, VMWareDatastore> datastores = (LinkedHashMap<Object, VMWareDatastore>) host.getAllDataStores();

        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();
        if (availablePerfCounters.get(DATASTORE_NUMBERREADAVERAGED_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_NUMBERWRITEAVERAGED_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_READ_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_WRITE_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_TOTALREADLATENCY_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_TOTALWRITELATENCY_AVERAGE) == null) {
            logger.debug(MessageFormat.format(MSG_HOST_DOESNT_SUPPORT_DATASTORE_STATS, host.getName()));
            return;
        }
        
        for (VMWareDatastore ds : datastores.values()) {
        	PerfEntityMetricBase[] perfResults = parser.retrieveHostNasDatastoreStats(host.getName(), ds.getName());
        	processHostNasDatastoreStatsResults(context, host, perfResults, ds);
        }
    }

    *//**
     * This method will query virtual machine datastore IO stats.
     * 
     * @param context - VMWare context object.
     * @param host - host Object.
     *//*
    private void queryVirtualMachineNasDatastoreStats(IVMWareContext context, VMWareHost host) {
        Set<Object> datastoreMoRefs = host.getAllDataStores().keySet();
        if (datastoreMoRefs == null || datastoreMoRefs.isEmpty()) {
            return;
        }

        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();
        if (availablePerfCounters.get(DATASTORE_NUMBERREADAVERAGED_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_NUMBERWRITEAVERAGED_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_READ_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_WRITE_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_TOTALREADLATENCY_AVERAGE) == null
                || availablePerfCounters.get(DATASTORE_TOTALWRITELATENCY_AVERAGE) == null) {
            logger.debug(MessageFormat.format(MSG_HOST_DOESNT_SUPPORT_DATASTORE_STATS, host.getName()));
            return;
        }

        List<String> vmNames = new ArrayList<String>();
        for (VMWareVirtualMachine vm : host.getAllVirtualMachines().values()) {
            vmNames.add(vm.getName());
        }
        List<String> dsNames = new ArrayList<String>();
        for (VMWareDatastore ds : host.getAllDataStores().values()) {
            dsNames.add(ds.getName());
        }
        PerfEntityMetricBase[] perfResults = parser.retrieveVirtualMachineNasDatastoreStats(host.getName(), vmNames,
                dsNames);
        processVirtualMachineNasDatastoreStatsResults(context, host, perfResults);
    }

    *//**
     * This method will query virtual machine IO stats.
     * 
     * @param context - VMWare context object.
     * @param host - host Object.
     *//*
    private void queryVirtualMachineIOStats(IVMWareContext context, VMWareHost host) {
        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();

        populateAllVmsLuns(host);

        List<String> vmNames = new ArrayList<String>();
        for (VMWareVirtualMachine vm : host.getAllVirtualMachines().values()) {
            vmNames.add(vm.getName());
        }
        List<String> lunNames = new ArrayList<String>();
        for (Object lun : host.getAllScsiLUNs()) {
            lunNames.add(((ScsiLun) lun).getCanonicalName());
        }
        PerfEntityMetricBase[] perfResults = parser.retrieveVirtualMachineLunStats(host.getName(), vmNames, lunNames);
        processVirtualMachineIOStatsResults(context, host, availablePerfCounters, perfResults);
    }

    *//**
     * This method populates all the VMs with its relevant LUNs.
     * 
     * @param host - Host object.
     *//*
    private void populateAllVmsLuns(VMWareHost host) {
        for (VMWareVirtualMachine vm : host.getAllVirtualMachines().values()) {
            for (VMWareDatastore ds : vm.getAllDataStores().values()) {
                if (ds != null && ds.getDataStoreInfo() instanceof VmfsDatastoreInfo) {
                    VmfsDatastoreInfo dsInfo = (VmfsDatastoreInfo) ds.getDataStoreInfo();

                    // retrieve the uuid of the datastore so it can be correlated to a HostFileSystemMountInfo volume
                    // once this is correlated, the HostFileSystemMountInfo volume can be correlated to a scsiLun by
                    // matching the scsiLun.canonicalName to the HostFileSystemMountInfo.volume.extent.diskName
                    String dataStoreUuid = dsInfo.getVmfs().getUuid();

                    String diskName = dataStoreUuid.split(" datastore", 2)[0];

                    // populate the virtual machine lun with the correlated diskname
                    populateVmLuns(host, vm, ds, diskName);
                } else if (ds != null && ds.getDataStoreInfo() instanceof NasDatastoreInfo) {
                    NasDatastoreInfo dsInfo = (NasDatastoreInfo) ds.getDataStoreInfo();

                    String diskName = dsInfo.getUrl();
                    populateVmLuns(host, vm, ds, diskName);
                }
            }
        }
    }

    *//**
     * This method will query all the virtual machine stats needed.
     * 
     * @param context - VMWare Connection.
     * @param host - host object.
     *//*
    private void queryVMStats(IVMWareContext context, VMWareHost host) {

        LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines = host.getAllVirtualMachines();

        populateCpuAndMemoryShares(virtualMachines);

        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();
        int samplePeriod = host.getSamplePeriod();

        List<String> vmNames = new ArrayList<String>();
        for (VMWareVirtualMachine vm : host.getAllVirtualMachines().values()) {
            vmNames.add(vm.getName());
        }
        PerfEntityMetricBase[] perfResults = parser.retrieveVirtualMachineStats(host.getName(), vmNames);

        processVMStatsResults(context, host, virtualMachines, availablePerfCounters, perfResults, samplePeriod);
    }

    *//**
     * This method will return the performance stats for host Lun's.
     * 
     * @param context - VMware API connection details.
     * @param host - Host System Managed Object Reference.
     *//*
    private void queryHostLUNStats(IVMWareContext context, VMWareHost host) {
        // In some cases the scsi luns array is null. This can happen when all datastores are NFS and there are no local
        // disks
        if (host.getAllScsiLUNs() == null || host.getAllScsiLUNs().length == 0) {
            logger.info("Host " + host.getName() + " has no scsi luns, no lun statistics to process.");
            return;
        }

        // there are scsi luns to process, cast to ScsiLun array to gather the appropriate information
        ScsiLun[] scsiLUNs = (ScsiLun[]) host.getAllScsiLUNs();

        // The following check is for the case when only local disk is a cdrom device
        if (scsiLUNs.length == 1) {
            ScsiLun lun = scsiLUNs[0];
            if ("cdrom".equals(lun.getLunType())) {
                logger.warn(MessageFormat.format(MSG_PERF_QUERY_SKIPPED_NO_LUNS_WITH_STATS, host.getHostName()));
                return;
            }
        }

        List<String> lunNames = new ArrayList<String>();
        for (Object lun : host.getAllScsiLUNs()) {
            lunNames.add(((ScsiLun) lun).getCanonicalName());
        }
        PerfEntityMetricBase[] perfResults = parser.retrieveHostLunStats(host.getName(), lunNames);
        processHostLUNStatsResults(context, host, perfResults);
    }

    *//**
     * This retrieves the host stats.
     * 
     * @param context - Connection details.
     * @param host - host object.
     *//*
    private void queryHostStats(IVMWareContext context, VMWareHost host) {
        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();
        PerfEntityMetricBase[] perfResults = parser.retrieveHostStats(host.getName());
        processHostStatsResults(context, host, availablePerfCounters, perfResults);
    }

    *//**
     * This method will query and populate the performance statistics for Ethernet ports of a host.
     * 
     * @param context - vmware context
     * @param host - host managed object reference
     *//*
    private void queryHostEthernetPortStats(IVMWareContext context, VMWareHost host) {
        Map<String, Integer> availablePerfCounters = host.getAvailablePerfCounters();
        List<String> pnicNames = new ArrayList<String>(host.getAllPhysicalNics().keySet());
        PerfEntityMetricBase[] perfResults = parser.retrieveHostEthernetPortStats(host.getName(), pnicNames);
        processHostEthernetPortStatsResults(context, host, availablePerfCounters, perfResults);
    }

    *//**
     * Always return true here.
     * 
     * @param context - vmware context
     * @param timestampInMilliSeconds - timestamp of the collected statistic in milliseconds
     * @return false if the timestamp of the collected statistic is less than fifteen minutes ago
     *//*
    protected boolean validateCollectedStatisticTimestamp(IVMWareContext context, long timestampInMilliSeconds) {
        return true;
    }

    *//** {@inheritDoc} *//*
    public LinkedHashMap<Object, VMWareDatastore> retrieveAllPropertiesOfHostDataStores(IVMWareContext context,
            VMWareHost host) {
        LinkedHashMap<Object, VMWareDatastore> hostDatastores = new LinkedHashMap<Object, VMWareDatastore>();

        if (host.getAllDataStores() != null && host.getAllDataStores().size() > 0) {
            ObjectContent[] dataStoreResult = parser.retrieveAllPropertiesOfHostDataStores(host.getName());
            IVMWare25CollectionFactory collectionFactory = new VMWare25CollectionFactory();
            hostDatastores = collectionFactory.createVMWareDatastoreCollectionObjects(dataStoreResult);
        }

        return hostDatastores;
    }

    *//** {@inheritDoc} *//*
    public VMWareVirtualCenter queryVirtualCenterSummary(IVMWareContext context) {
        ObjectContent[] result = parser.retrieveAllHosts();

        // create virtual center collection object to return to the collector
        VMWareVirtualCenter virtualCenter = new VMWareVirtualCenter();

        // check if the query returned a result. The result can be null when there are no hosts
        // or clusters in the virtual center environment
        if (result == null) {
            return virtualCenter;
        }

        IVMWare25CollectionFactory collectionFactory = new VMWare25CollectionFactory();
        LinkedHashMap<Object, VMWareCluster> clusters = new LinkedHashMap<Object, VMWareCluster>();
        ManagedObjectReference clusterMor = new ManagedObjectReference();
        clusterMor.setType("ClusterComputeResource");
        clusterMor.set_value("cluster1");
        VMWareCluster cluster = new VMWareCluster(clusterMor);
        clusters.put(clusterMor, cluster);
        LinkedHashMap<Object, VMWareHost> hosts = collectionFactory.createVMWareHostCollectionObjects(result);

        // add hosts to clusters (hosts only contain name and uuid)
        for (VMWareCluster clus : clusters.values()) {
            for (VMWareHost host : hosts.values()) {
                clus.putHost(host.getManagedObject(), host);
            }
        }

        virtualCenter.setAllComputeResources(new LinkedHashMap<Object, VMWareComputeResource>());
        virtualCenter.setAllClusters(clusters);

        return virtualCenter;
    }

    *//**
     * {@inheritDoc}
     *//*
    public VMWareHost queryHostAndVirtualMachineDetailsForStatistics(IVMWareContext context, Map<String, String> state,
            Object hostMor) {
        // Host name is saved in Mor.get_value()
        ObjectContent[] result = parser.retrieveHostAndVirtualMachineDetailsForStatistics(((ManagedObjectReference) hostMor).get_value());
        return processHostStats(context, state, (ManagedObjectReference) hostMor, result);
    }

    *//**
     * This method is used to process host stats.
     * 
     * @param context - VMWare context object.
     * @param state - State map.
     * @param hostMor - Host managed object reference.
     * @param result - Object content array.
     * @return - VMWareHost object with stats.
     *//*
    private VMWareHost processHostStats(IVMWareContext context, Map<String, String> state,
            ManagedObjectReference hostMor, ObjectContent[] result) {

        IVMWare25CollectionFactory collectionFactory = new VMWare25CollectionFactory();
        VMWareHost host = collectionFactory.createVMWareHostCollectionObject(result, hostMor);

        // If the host is powered off, in standby mode, not connected or is in maintenance mode, skip processing
        // statistics.
        if (VirtualCenterCollectorService.getServerPowerStateForString(host.getPowerState()).equals(
                ServerPowerState.POWERED_OFF)
                || VirtualCenterCollectorService.getServerPowerStateForString(host.getPowerState()).equals(
                        ServerPowerState.STANDBY)
                || !VirtualCenterCollectorService.getConnectionStateForString(host.getConnectionState()).equals(
                        ConnectionState.CONNECTED) || host.getMaintenanceMode()) {
            logger.warn("Host " + host.getName() + " is not available for statistics collection. Power State="
                    + host.getPowerState() + ", Connection State=" + host.getConnectionState() + ", Maintenance Mode="
                    + host.getMaintenanceMode());
            return host;
        }

        LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines = collectionFactory.createVMWareVirtualMachineCollectionObjects(result);

        // Enable this
        if (host.getAllDataStores() != null && host.getAllDataStores().size() > 0) {
            ObjectContent[] dataStoreResult = parser.retrieveAllPropertiesOfHostDataStores(host.getName());
            LinkedHashMap<Object, VMWareDatastore> hostDatastores = collectionFactory.createVMWareDatastoreCollectionObjects(dataStoreResult);
            host.setAllDataStores(hostDatastores);
        }

        LinkedHashMap<Object, VMWareVirtualMachine> poweredOnVirtualMachines = new LinkedHashMap<Object, VMWareVirtualMachine>();
        for (VMWareVirtualMachine vm : virtualMachines.values()) {
            if (!vm.isTemplate() && !vm.isSecondary()) {
                vm.setHost(host);
                poweredOnVirtualMachines.put(vm.getManagedObject(), vm);
            } else {
                logger.debug("Template found. Name: " + vm.getName());
            }
        }

        host.setAllVirtualMachines(poweredOnVirtualMachines);

        for (VMWareVirtualMachine vm : host.getAllVirtualMachines().values()) {
            LinkedHashMap<Object, VMWareDatastore> dataStores = new LinkedHashMap<Object, VMWareDatastore>();
            for (Object mor : vm.getAllDataStores().keySet()) {
                if (host.getDatastore(mor) != null) {
                    dataStores.put(mor, host.getDatastore(mor));
                }
            }
            vm.setAllDataStores(dataStores);
        }

        for (VMWareDatastore ds : host.getAllDataStores().values()) {
            LinkedHashMap<Object, VMWareVirtualMachine> vms = new LinkedHashMap<Object, VMWareVirtualMachine>();
            for (Object mor : ds.getAllVirtualMachines().keySet()) {
                if (host.getVirtualMachine(mor) != null) {
                    vms.put(mor, host.getVirtualMachine(mor));
                }
            }
            ds.setAllVirtualMachines(vms);
        }

        host.setSamplePeriod((int) VMWare25CsvStatParser.SAMPLE_PERIOD_MS / 1000);
        logger.debug("Host \"" + host.getName() + "\" statistics sampling period: " + host.getSamplePeriod());
        host.setAvailablePerfCounters(parser.retrieveAvailablePerfMetricMaps());

        if (VMWareLoggerHelper.logToRawFile()) {
            CollectorLog.printlnToRaw(RAW_FILE_HOST_HEADER + host.getName() + " (" + host.getProductFullName() + ")" );
        }

        queryHostStats(context, host);
        queryHostLUNStats(context, host);
        queryHostEthernetPortStats(context, host);
        queryHostNasDatastoreStats(context, host);
        if (!poweredOnVirtualMachines.isEmpty()) {
            queryVMStats(context, host);
            queryVirtualMachineIOStats(context, host);
            queryVirtualMachineNasDatastoreStats(context, host);
        }

        return host;
    }

    *//**
     * {@inheritDoc}
     *//*
    public boolean isVirtualCenterStatsLevelSupported(IVMWareContext context) {
        return false;
    }

    *//** {@inheritDoc} *//*
    public String getVirtualCenterVersion(IVMWareContext context) {
        return "";
    }

    *//** {@inheritDoc} *//*
    public int getHostCount(VMWareVirtualCenter virtualCenter) {
        int hostCount = 0;
        // Check for hosts belonging to clusters to include in count
        if (virtualCenter.getAllClusters().size() > 0) {
            for (VMWareCluster cluster : virtualCenter.getAllClusters().values()) {
                hostCount += cluster.getAllHosts().size();
            }
        }

        // include non-clustered hosts in count
        for (VMWareComputeResource computeResource : virtualCenter.getAllComputeResources().values()) {
            // Add hosts belonging to resource pools
            hostCount += computeResource.getAllHosts().size();
        }

        return hostCount;
    }

    *//** {@inheritDoc} *//*
    public int getTotalNumberOfMonitoredHostsInVC(VMWareVirtualCenter vc, VirtualCenterAccessHandle vcAccessHandle,
            IVMWareContext context) {
        int count = 0;

        for (VMWareCluster cluster : vc.getAllClusters().values()) {
            count += cluster.getAllHosts().size();
        }

        for (VMWareComputeResource comRes : vc.getAllComputeResources().values()) {
            // only include monitored hosts in count
            for (VMWareHost thinHost : comRes.getAllHosts().values()) {
                Map<String, IVirtualCenterConfiguration> vcConfigMap = vcAccessHandle.getVirtualCenterConfigurationMap();
                IVirtualCenterConfiguration vcConfig = vcConfigMap.get(VirtualCenterCollectorService.formatUuid(thinHost.getUuid()));

                // there is a configuration or the virtual center is in automonitor everything mode
                if (vcConfig != null || vcAccessHandle.getAutomonitorCollected()) {
                    // un-clustered host is monitored or vc is in collect everything mode.

                    // check if the host collected has a non-empty uuid and it is not an invalid uuid
                    if (thinHost.getUuid() != null
                            && !thinHost.getUuid().equalsIgnoreCase(IVMWareService.INVALID_UUID_ALL_F)) {
                        // the collected host also has a non-empty uuid and is not invalid, include in count
                        count++;
                    }
                }
            }
        }
        return count;
    }

    *//** {@inheritDoc} *//*
    public boolean filterCluster(VMWareCluster cluster, VirtualCenterAccessHandle vcAccessHandle, IVMWareContext context) {
        return false;
    }

    *//** {@inheritDoc} *//*
    public boolean filterHost(VMWareHost host, VirtualCenterAccessHandle vcAccessHandle) {
        return false;
    }*/
}
