/*
 * Copyright (c) 2011 NetApp
 * All rights reserved
 */

package com.netapp.collectors.vmware;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;

import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfMetricIntSeries;

/**
 * This is a helper class which provides perf stats counter processing
 * functions to be used within the VMWare25Service class.
 * 
 * @author mkahlke
 *
 */
public class VMWare25ServiceHelper {
    
   /* *//** Logger. *//*
    private static final Logger logger = Logger.getLogger(VMWare25ServiceHelper.class);

    *//**
     * Process statistics counter results.  See description of next method below for details.
     * @param context IVMWareContext
     * @param host vmware host collection object
     * @param counterName name of counter
     * @param intSeries PerfMetricIntSeries
     * @param metric PerfEntityMetric
     * @param paramMap map used to pass parameters into and results back out of this method
     *//*
    public static void processCounterResults(IVMWareContext context, VMWareHost host, String counterName,
            PerfMetricIntSeries intSeries, PerfEntityMetric metric, Map<String, Object> paramMap) {

        processCounterResults(context, host, null, counterName, intSeries, metric, paramMap);
    }

    *//**
     * Process statistics counter results.  All other methods above are variants of this method.
     *
     * Java passes references by value which is why we use a parameter map to hold multiple results.
     *
     * The following optional parameters are handled:
     *
     *   "counterValue" (Float) : initial value of accumulate sample counter, null if not specififed
     *   "rawSampleValues" (ArrayList<Float>) : raw samples (only populated if passed in)
     *   "multipliers" (ArrayList<Float>) : per-sample multipliers (only used if passed in)
     *   "upperLimit" (Long) : optional maximum value (only used if passed in)
     *   "ceiling" (Long) : optional ceiling value, used in conjunction with "upperLimit", values
     *                      between this and upperLimit will be set to upperLimit but only if
     *                      "upperLimit" is specified
     *
     * The following parameters are always passed back to the caller:
     *
     *   "counterValue" (Float) : sum of valid counter samples (entry passed in or created)
     *   "numValidSamples" (Integer) : number of valid counter samples (entry created)
     *
     * Note that if there we no valid samples, "counterValue" would hold a null object, and
     * "numValidSamples" would contain an Integer with the value of 0 (zero).
     *
     * @param context IVMWareContext
     * @param host vmware host collection object
     * @param vm vmware virtual machine collection object
     * @param counterName name of counter
     * @param intSeries PerfMetricIntSeries
     * @param metric PerfEntityMetric
     * @param paramMap map used to pass parameters/results in/out of this method
     *//*
    public static void processCounterResults(IVMWareContext context, VMWareHost host, VMWareVirtualMachine vm,
            String counterName, PerfMetricIntSeries intSeries, PerfEntityMetric metric, Map<String, Object> paramMap) {

        Integer numValidSamples = 0;
        Float counterValue = (Float) paramMap.get(VMWareServiceHelper.COUNTER_VALUE);
        ArrayList<Float> rawSampleValues = (ArrayList<Float>) paramMap.get(VMWareServiceHelper.RAW_SAMPLE_VALUES);
        ArrayList<Float> multipliers = (ArrayList<Float>) paramMap.get(VMWareServiceHelper.MULTIPLIERS);
        Long upperLimit = (Long) paramMap.get(VMWareServiceHelper.UPPER_LIMIT);
        Long ceiling = (Long) paramMap.get(VMWareServiceHelper.CEILING);

        int numInvalidSamples = 0;
        long lastStatTime = 0; // last stat time, for checking gaps between samples
        int numRawSamples = intSeries.getValue().length;
        logger.debug("Collected " + numRawSamples + " samples for counter " + counterName);
        for (int k = 0; k < numRawSamples; k++) {
            long longValue = intSeries.getValue(k);
            logger.debug("Sample:( " + k + ") " + longValue + " sample time: " + metric.getSampleInfo(k).getTimestamp().getTime());
            if (rawSampleValues != null) {
                rawSampleValues.add(new Float(longValue));
            }
            if (VMWareLoggerHelper.logToRawFile()) {
                long curStatTime = metric.getSampleInfo(k).getTimestamp().getTimeInMillis();
                VMWareLoggerHelper.printStatToRawFile(intSeries.getId().getCounterId(), counterName,
                        longValue, k == 0, k == numRawSamples - 1, curStatTime, lastStatTime);
                lastStatTime = curStatTime;
            }

            if (validateCollectedStatisticTimestamp(
                    context,
                    metric.getSampleInfo(k).getTimestamp().getTimeInMillis()) == false) {
            	logger.debug("Invalid sample time: " + metric.getSampleInfo(k).getTimestamp().getTime() + " fifteen min ago timestamp in context: " + context.getTimeFiveMinAgo().getTime());
                if (host != null && vm != null) {
                    logger.debug(MessageFormat.format(
                            VMWareServiceHelper.MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_VIRTUAL_MACHINE,
                            counterName,
                            vm.getName(),
                            host.getHostName(),
                            metric.getSampleInfo(k).getTimestamp()));
                    CollectorLog.debug("[VMWare25ServiceHelper] Skipping stale " + counterName + " statistic " + longValue +
                            " for virtual machine : " + vm.getName() + " on host : " + host.getHostName() + "." + " Timestamp " +
                            metric.getSampleInfo(k).getTimestamp().getTime());
                } else if (host != null && vm == null) {
                    logger.debug(MessageFormat.format(
                            VMWareServiceHelper.MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_HOST_SERVER,
                            counterName,
                            host.getHostName(),
                            metric.getSampleInfo(numRawSamples - 1).getTimestamp()));
                    CollectorLog.debug("[VMWare25ServiceHelper] Skipping stale " + counterName + " statistic " + longValue +
                            " for host server : " + host.getHostName() + "." + " Timestamp " +
                            metric.getSampleInfo(k).getTimestamp().getTime());
                }
                continue; // stale data, continue from next sample
            }

            String entityName = "UNKNOWN";
            if (vm != null) {
                entityName = "VM " + vm.getName();
            } else if (host != null) {
                entityName = "Host " + host.getHostName();
            }

            if (longValue < 0L) {
                numInvalidSamples++;
                logger.debug(MessageFormat.format(
                    VMWareServiceHelper.MSG_SKIPPING_SAMPLE_DUE_TO_NEGATIVE_VALUE,
                    counterName, k, entityName, longValue));
                continue;   // for loop
            }

            Float multFactor = 1F;
            if (multipliers != null && multipliers.get(k) != null) {
                multFactor = multipliers.get(k);
                if (multFactor < 0L) {
                    numInvalidSamples++;
                    logger.debug(MessageFormat.format(
                        VMWareServiceHelper.MSG_SKIPPING_SAMPLE_DUE_TO_NEGATIVE_FACTOR,
                        counterName, k, entityName, multFactor));
                    continue;   // for loop
                }
            }

            if (upperLimit != null && ceiling != null) {
                if (longValue <= upperLimit) {
                    if (counterValue == null) {
                        counterValue = new Float(longValue).floatValue() * multFactor;
                    } else {
                        counterValue += new Float(longValue).floatValue() * multFactor;
                    }
                    numValidSamples++;
                } else if (longValue <= ceiling) {
                    // The statistic is greater than the upperLimit but it is no greater
                    // than the ceiling, so set the stat to the upperLimit.
                    if (counterValue == null) {
                        counterValue = new Float(upperLimit) * multFactor;
                    } else {
                        counterValue += new Float(upperLimit) * multFactor;
                    }
                    numValidSamples++;
                } else {
                    numInvalidSamples++;
                    logger.debug(MessageFormat.format(
                        VMWareServiceHelper.MSG_SKIPPING_SAMPLE_DUE_TO_CEILING_VIOLATION,
                        counterName, k, entityName, longValue, ceiling));
                }
            } else if (upperLimit != null) {
                if (longValue <= upperLimit) {
                    if (counterValue == null) {
                        counterValue = new Float(longValue).floatValue() * multFactor;
                    } else {
                        counterValue += new Float(longValue).floatValue() * multFactor;
                    }
                    numValidSamples++;
                } else {
                    numInvalidSamples++;
                    logger.debug(MessageFormat.format(
                        VMWareServiceHelper.MSG_SKIPPING_SAMPLE_DUE_TO_UPPER_LIMIT_VIOLATION,
                        counterName, k, entityName, longValue, upperLimit));
                }
            } else {
                if (counterValue == null) {
                    counterValue = new Float(longValue).floatValue() * multFactor;
                } else {
                    counterValue += new Float(longValue).floatValue() * multFactor;
                }
                numValidSamples++;
            }

            if(numInvalidSamples > 0){
        	    logger.debug("Collected " + numInvalidSamples + " invalid " + counterName + " sample(s)");
            }
        }
        logger.debug("Collected " + numValidSamples + " valid " + counterName + " sample(s). Counter value is " + counterValue);
        // Pass results back to caller
        paramMap.put(VMWareServiceHelper.COUNTER_VALUE, counterValue);
        paramMap.put(VMWareServiceHelper.NUM_VALID_SAMPLES, numValidSamples);
    }

    *//**
     * Validate the timestamp of the collected statistic.  If the timestamp of the collected statistic
     * is less than fifteen minutes ago, this method will return false.
     *
     * @param context vmware context
     * @param timestampInMilliSeconds timestamp of the collected statistic in milliseconds
     * @return false if the timestamp of the collected statistic is less than fifteen minutes ago
     *//*
    public static boolean validateCollectedStatisticTimestamp(IVMWareContext context, long timestampInMilliSeconds) {
        if (timestampInMilliSeconds < context.getTimeFiveMinAgo().getTimeInMillis()) {
            return false;
        } else {
            return true;
        }
    }*/

}
