/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

import java.util.LinkedHashMap;

/**
 * Compute Resource.
 * 
 * @author dhetti
 *
 */
public class VMWareComputeResource {

    /** Name of this compute resource. */
    private String name;
    
    /** Managed object of this compute resource. */
    private Object managedObject;
    
    /** Resource pools which contains all resource pools for this compute resource. */
    @Deprecated
    private LinkedHashMap<Object, VMWareResourcePool> resourcePools = new LinkedHashMap<Object, VMWareResourcePool>();
    
    /** Contains the root resource pool. **/
    private VMWareResourcePool rootResourcePool;
    
    /** Hosts contained in this compute resource. */
    private LinkedHashMap<Object, VMWareHost> hosts = new LinkedHashMap<Object, VMWareHost>();
    
    /** Datastores contained by this compute resource. */
    private LinkedHashMap<Object, VMWareDatastore> datastores = new LinkedHashMap<Object, VMWareDatastore>();    
    
    /** Overall status of this compute resource. */
    private String overallStatus;
    
    /**
     * Constructor.
     * 
     * @param managedObject managed object of this compute resource
     */
    public VMWareComputeResource(Object managedObject){
        this.managedObject = managedObject;
    }
    
    /**
     * Gets the name of this compute resource.
     * 
     * @return name name of this compute resource
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of this compute resource.
     * 
     * @param name name of this compute resource
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the managed object of this compute resource.
     * 
     * @return managedObject managed object id of this compute resource
     */
    public Object getManagedObject(){
        return this.managedObject;
    }
    
    /**
     * Sets the managed object of this compute resource.
     * 
     * @param managedObject managed object of this compute resource
     */
    public void setManagedObject(Object managedObject){
        this.managedObject = managedObject;
    }
    
    /**
     * Get Resource pools which contain resource pools associated with this compute resource.
     * 
     * @return resourcePools resource pools which contain resource pools associated with this compute resource
     * @deprecated
     */
    public LinkedHashMap<Object, VMWareResourcePool> getAllResourcePools() {
        return resourcePools;
    }

    /**
     * Gets a resource pool contained by this compute resource given the managed object id.
     * 
     * @param key managed object of the resource pool
     * @return resource pool a resource pool contained by this compute resource given the managed object id
     * @deprecated
     */
    public VMWareResourcePool getResourcePool(Object key){
        return this.resourcePools.get(key);
    }
    
    /**
     * Sets resource pool which contains resource pools associated with this compute resource.
     * 
     * @param key managed object of the resource pool
     * @param resourcePool resource pool which contains resource pools associated with this compute resource
     * @deprecated
     */
    public void putResourcePool(Object key, VMWareResourcePool resourcePool) {
        this.resourcePools.put(key, resourcePool);
    }

    /**
     * Gets all hosts contained by this compute resource.
     * 
     * @return hosts all hosts contained by this compute resource
     */
    public LinkedHashMap<Object, VMWareHost> getAllHosts(){
        return this.hosts;
    }
    
    /**
     * Gets a host contained by this compute resource given the managed object id.
     * 
     * @param key managed object of the host
     * @return host a host contained by this compute resource given the managed object id
     */
    public VMWareHost getHost(Object key) {
        return this.hosts.get(key);
    }

    /**
     * Set a hosts contained by this compute resource.
     * 
     * @param key managed object of the host
     * @param host host object contained by this compute resource
     */
    public void putHost(Object key, VMWareHost host) {
        this.hosts.put(key, host);
    }

    /**
     * Gets the overall status of this compute resource.
     * 
     * @return overallStatus overall status of this compute resource
     */
    public String getOverallStatus() {
        return overallStatus;
    }

    /**
     * Sets the overall status of this compute resource.
     * 
     * @param overallStatus overall status of this compute resource
     */
    public void setOverallStatus(String overallStatus) {
        this.overallStatus = overallStatus;
    }
    
    /**
     * Gets all datastores contained by this compute resource.
     * 
     * @return datastores all datastores contained by this compute resource
     */
    public LinkedHashMap<Object, VMWareDatastore> getAllDatastores(){
        return this.datastores;
    }
    
    /**
     * Gets a datastore contained by this compute resource.
     * 
     * @param key managed object of this virtual machine
     * @return datastore datastore object contained by this compute resource
     */
    public VMWareDatastore getDatastore(Object key) {
        return this.datastores.get(key);
    }

    /**
     * Sets a datastore contained by this compute resource.
     * 
     * @param key managed object of the virtual machine
     * @param datastore datastore object contained by this compute resource
     */
    public void putDatastore(Object key, VMWareDatastore datastore) {
        this.datastores.put(key, datastore);
    }

    /**
     * Gets the root resource pool.
     * 
     * @return - root resource pool.
     */
    public VMWareResourcePool getRootResourcePool() {
        return rootResourcePool;
    }

    /**
     * sets the root resource pool.
     * 
     * @param rootResourcePool - Root resource pool.
     */
    public void setRootResourcePool(VMWareResourcePool rootResourcePool) {
        this.rootResourcePool = rootResourcePool;
    }    
}
