/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

/**
 * Collection domain object for VMware SCSI LUNs.
 * 
 * @author Akorri Offshore Team
 *
 */
public class VMWareLUN {

    private String canonicalName;

    private Long readIOAbs;

    private Long writeIOAbs;

    private Float readDataPs;

    private Float writeDataPs;

    private Long deviceLatency;

    private Long queueLatency;

    private Long totalLatency;

    private int numSamplesReadIOs;

    private int numSamplesWriteIOs;
    
    private int numSamplesReadData;
    
    private int numSamplesWriteData;

    private int numSamplesDeviceLatency;

    private int numSamplesQueueLatency;

    private int numSamplesTotalLatency;

    /**
     * Default constructor.
     */
    public VMWareLUN() {
    }

    /**
     * Constructor with the canonical name parameter.
     * 
     * @param canonicalName the canonical name of the LUN
     */
    public VMWareLUN(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    /**
     * Gets the canonical name of the LUN.
     * 
     * @return the canonical name of the LUN
     */
    public String getCanonicalName() {
        return this.canonicalName;
    }

    /**
     * Sets the canonical name of the LUN.
     * 
     * @param canonicalName the canonical name of the LUN to set
     */
    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    /**
     * Gets the absolute number of read IOs.
     * 
     * @return the absolute number of read IOs
     */
    public Long getReadIOAbs() {
        return this.readIOAbs;
    }

    /**
     * Sets the absolute number of read IOs.
     * 
     * @param readIOAbs the absolute number of read IOs to set
     */
    public void setReadIOAbs(Long readIOAbs) {
        this.readIOAbs = readIOAbs;
    }

    /**
     * Gets the absolute number of write IOs.
     * 
     * @return the absolute number of write IOs
     */
    public Long getWriteIOAbs() {
        return this.writeIOAbs;
    }

    /**
     * Sets the absolute number of write IOs.
     * 
     * @param writeIOAbs the absolute number of write IOs to set
     */
    public void setWriteIOAbs(Long writeIOAbs) {
        this.writeIOAbs = writeIOAbs;
    }

    /**
     * Gets the average number of kilo bytes read per second.
     * 
     * @return the average number of kilo bytes read per second
     */
    public Float getReadDataPs() {
        return this.readDataPs;
    }

    /**
     * Sets the average number of kilo bytes read per second.
     * 
     * @param readDataPs the average number of kilo bytes read per second to set
     */
    public void setReadDataPs(Float readDataPs) {
        this.readDataPs = readDataPs;
    }

    /**
     * Gets the average number of kilo bytes written per second.
     * 
     * @return the average number of kilo bytes written per second
     */
    public Float getWriteDataPs() {
        return this.writeDataPs;
    }

    /**
     * Sets the average number of kilo bytes written per second.
     * 
     * @param writeDataPs the average number of kilo bytes written per second to set
     */
    public void setWriteDataPs(Float writeDataPs) {
        this.writeDataPs = writeDataPs;
    }

    /**
     * Gets the device latency.
     * 
     * @return the device latency
     */
    public Long getDeviceLatency() {
        return this.deviceLatency;
    }

    /**
     * Sets the device latency.
     * 
     * @param deviceLatency the device latency to set
     */
    public void setDeviceLatency(Long deviceLatency) {
        this.deviceLatency = deviceLatency;
    }

    /**
     * Gets the queue latency.
     * 
     * @return the queue latency
     */
    public Long getQueueLatency() {
        return this.queueLatency;
    }

    /**
     * Sets the queue latency.
     * 
     * @param queueLatency the queue latency to set
     */
    public void setQueueLatency(Long queueLatency) {
        this.queueLatency = queueLatency;
    }

    /**
     * Gets the total latency.
     * 
     * @return the total latency
     */
    public Long getTotalLatency() {
        return this.totalLatency;
    }

    /**
     * Sets the total latency.
     * 
     * @param totalLatency the total latency to set
     */
    public void setTotalLatency(Long totalLatency) {
        this.totalLatency = totalLatency;
    }

    /**
     * Gets the number of read IO samples.
     * 
     * @return the number of read IO samples
     */
    public int getNumSamplesReadIOs() {
        return this.numSamplesReadIOs;
    }

    /**
     * Sets the number of read IO samples.
     * 
     * @param numSamplesReadIOs the number of read IO samples to set
     */
    public void setNumSamplesReadIOs(int numSamplesReadIOs) {
        this.numSamplesReadIOs = numSamplesReadIOs;
    }

    /**
     * Gets the number of write IO samples.
     * 
     * @return the number of write IO samples
     */
    public int getNumSamplesWriteIOs() {
        return this.numSamplesWriteIOs;
    }

    /**
     * Sets the number of write IO samples.
     * 
     * @param numSamplesWriteIOs the number of write IO samples to set
     */
    public void setNumSamplesWriteIOs(int numSamplesWriteIOs) {
        this.numSamplesWriteIOs = numSamplesWriteIOs;
    }

    /**
     * Gets the number of read data samples.
     * 
     * @return the number of read data samples
     */
    public int getNumSamplesReadData() {
        return this.numSamplesReadData;
    }

    /**
     * Sets the number of read data samples.
     * 
     * @param numSamplesReadData the number of read data samples to set
     */
    public void setNumSamplesReadData(int numSamplesReadData) {
        this.numSamplesReadData = numSamplesReadData;
    }

    /**
     * Gets the number of write data samples.
     * 
     * @return the number of write data samples
     */
    public int getNumSamplesWriteData() {
        return this.numSamplesWriteData;
    }

    /**
     * Sets the number of write data samples.
     * 
     * @param numSamplesWriteData the number of write data samples to set
     */
    public void setNumSamplesWriteData(int numSamplesWriteData) {
        this.numSamplesWriteData = numSamplesWriteData;
    }

    /**
     * Gets the number of device latency samples.
     * 
     * @return the number of device latency samples
     */
    public int getNumSamplesDeviceLatency() {
        return this.numSamplesDeviceLatency;
    }

    /**
     * Sets the number of device latency samples.
     * 
     * @param numSamplesDeviceLatency the number of device latency samples to set
     */
    public void setNumSamplesDeviceLatency(int numSamplesDeviceLatency) {
        this.numSamplesDeviceLatency = numSamplesDeviceLatency;
    }

    /**
     * Gets the number of queue latency samples.
     * 
     * @return the number of queue latency samples
     */
    public int getNumSamplesQueueLatency() {
        return this.numSamplesQueueLatency;
    }

    /**
     * Sets the number of queue latency samples.
     * 
     * @param numSamplesQueueLatency the number of queue latency samples to set
     */
    public void setNumSamplesQueueLatency(int numSamplesQueueLatency) {
        this.numSamplesQueueLatency = numSamplesQueueLatency;
    }

    /**
     * Gets the number of total latency samples.
     * 
     * @return the number of total latency samples
     */
    public int getNumSamplesTotalLatency() {
        return this.numSamplesTotalLatency;
    }

    /**
     * Sets the number of total latency samples.
     * 
     * @param numSamplesTotalLatency the number of total latency samples to set
     */
    public void setNumSamplesTotalLatency(int numSamplesTotalLatency) {
        this.numSamplesTotalLatency = numSamplesTotalLatency;
    }

}
