/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

/**
 * Collection domain object for VMware Physical Network Adapter.
 * 
 * @author Akorri Offshore Team
 * 
 */
public class VMWarePhysicalNic {

    /**
     * Overwritten toString
     */
    public String toString() {
        String s = "\nVMWarePhysicalNic:\n";
        s += "    Device Name            : " + deviceName + "\n";
        s += "    MAC Address            : " + macAddress + "\n";
        s += "    Is Link Duplex         : " + isLinkDuplex + "\n";
        s += "    Link Speed MB          : " + linkSpeedMB + "\n";
        s += "    Avg Data TX            : " + avgDataTransmitted + "\n";
        s += "    Num Samples Avg Data TX: " + numSamplesAvgDataTransmitted + "\n";
        s += "    Avg Data RX            : " + avgDataReceived + "\n";
        s += "    Num Samples Avg Data RX: " + numSamplesAvgDataReceived + "\n";
        s += "    Packets TX             : " + packetsTx + "\n";
        s += "    Num Samples Packets TX : " + numSamplesPacketsTx + "\n";
        s += "    Packets RX             : " + packetsRx + "\n";
        s += "    Num Samples Packets RX : " + numSamplesPacketsRx + "\n";

        return s;
    }

    /**
     * Device name of the physical network adapter.
     */
    private String deviceName;

    /**
     * Media access control (MAC) address of the physical network adapter.
     * 
     * @since VI API 2.5
     */
    private String macAddress;

    /**
     * Flag to indicate whether or not the link is capable of full-duplex ("true") or only half-duplex ("false").
     */
    private Boolean isLinkDuplex;

    /**
     * Bit rate on the link in MB.
     */
    private Integer linkSpeedMB;

    /**
     * Data transmitting rate in KBps.
     */
    private Float avgDataTransmitted;
    
    /**
     * Number of samples for data transmitting rate.
     */
    private Integer numSamplesAvgDataTransmitted;

    /**
     * Data receiving rate in KBps.
     */
    private Float avgDataReceived;
    
    /**
     * Number of samples for data receiving rate.
     */
    private Integer numSamplesAvgDataReceived;

    /**
     * Number of packets transmitted.
     */
    private Long packetsTx;
    
    /**
     * Number of samples for number of packets transmitted.
     */
    private Integer numSamplesPacketsTx;

    /**
     * Number of packets received.
     */
    private Long packetsRx;
    
    /**
     * Number of samples for number of packets received.
     */
    private Integer numSamplesPacketsRx;

    /**
     * Gets the device name of the physical network adapter.
     * 
     * @return the device name of the physical network adapter
     */
    public String getDeviceName() {
        return this.deviceName;
    }

    /**
     * Sets the device name of the physical network adapter.
     * 
     * @param deviceName - the device name of the physical network adapter to set
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    /**
     * Gets the mac address of the physical network adapter.
     * 
     * @return the mac address of the physical network adapter
     */
    public String getMacAddress() {
        return this.macAddress;
    }

    /**
     * Sets the mac address of the physical network adapter.
     * 
     * @param macAddress - the mac address of the physical network adapter to set
     */
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    /**
     * Gets the link capability of the physical network adapter.
     * 
     * @return the link capability of the physical network adapter
     */
    public Boolean isLinkDuplex() {
        return this.isLinkDuplex;
    }

    /**
     * Sets the link capability of the physical network adapter.
     * 
     * @param isLinkDuplex - the link capability of the physical network adapter to set
     */
    public void setLinkDuplex(Boolean isLinkDuplex) {
        this.isLinkDuplex = isLinkDuplex;
    }

    /**
     * Gets the link speed in MB of the physical network adapter.
     * 
     * @return the link speed in MB of the physical network adapter
     */
    public Integer getLinkSpeedMB() {
        return this.linkSpeedMB;
    }

    /**
     * Sets the link speed in MB of the physical network adapter.
     * 
     * @param linkSpeedMB - the link speed in MB of the physical network adapter to set
     */
    public void setLinkSpeedMB(Integer linkSpeedMB) {
        this.linkSpeedMB = linkSpeedMB;
    }

    /**
     * Gets the data transmitting rate in KBps of the physical network adapter.
     * 
     * @return the data transmitting rate in KBps of the physical network adapter
     */
    public Float getAvgDataTransmitted() {
        return this.avgDataTransmitted;
    }

    /**
     * Sets the data transmitting rate in KBps of the physical network adapter.
     * 
     * @param avgDataTransmitted - the data transmitting rate in KBps of the physical network adapter to set
     */
    public void setAvgDataTransmitted(Float avgDataTransmitted) {
        this.avgDataTransmitted = avgDataTransmitted;
    }

    /**
     * Gets the number of samples for the data transmitting rate.
     * 
     * @return the number of samples for the data transmitting rate
     */
    public Integer getNumSamplesAvgDataTransmitted() {
        return this.numSamplesAvgDataTransmitted;
    }

    /**
     * Sets the number of samples for the data transmitting rate.
     * 
     * @param numSamplesAvgDataTransmitted - the number of samples for the data transmitting rate
     */
    public void setNumSamplesAvgDataTransmitted(Integer numSamplesAvgDataTransmitted) {
        this.numSamplesAvgDataTransmitted = numSamplesAvgDataTransmitted;
    }

    /**
     * Gets the data receiving rate in KBps of the physical network adapter.
     * 
     * @return data receiving rate in KBps of the physical network adapter
     */
    public Float getAvgDataReceived() {
        return this.avgDataReceived;
    }

    /**
     * Sets the data receiving rate in KBps of the physical network adapter.
     * 
     * @param avgDataReceived - the data receiving rate in KBps of the physical network adapter to set
     */
    public void setAvgDataReceived(Float avgDataReceived) {
        this.avgDataReceived = avgDataReceived;
    }

    /**
     * Gets the number of samples for the data receiving rate.
     * 
     * @return the number of samples for data receiving rate
     */
    public Integer getNumSamplesAvgDataReceived() {
        return this.numSamplesAvgDataReceived;
    }

    /**
     * Sets the number of samples for the data receiving rate.
     * 
     * @param numSamplesAvgDataReceived - the number of samples for the data receiving rate
     */
    public void setNumSamplesAvgDataReceived(Integer numSamplesAvgDataReceived) {
        this.numSamplesAvgDataReceived = numSamplesAvgDataReceived;
    }

    /**
     * Gets the number of packets transmitted for the physical network adapter.
     * 
     * @return the number of packets transmitted for the physical network adapter
     */
    public Long getPacketsTx() {
        return this.packetsTx;
    }

    /**
     * Sets the number of packets transmitted for the physical network adapter.
     * 
     * @param packetsTx - the number of packets transmitted for the physical network adapter to set
     */
    public void setPacketsTx(Long packetsTx) {
        this.packetsTx = packetsTx;
    }

    /**
     * Gets the number of samples for the number of packets transmitted for the physical network adapter.
     * 
     * @return the number of samples for the number of packets transmitted for the physical network adapter
     */
    public Integer getNumSamplesPacketsTx() {
        return this.numSamplesPacketsTx;
    }

    /**
     * Sets the number of samples for the number of packets transmitted for the physical network adapter.
     * 
     * @param numSamplesPacketsTx - the number of samples for the number of packets transmitted for the physical network adapter to set
     */
    public void setNumSamplesPacketsTx(Integer numSamplesPacketsTx) {
        this.numSamplesPacketsTx = numSamplesPacketsTx;
    }

    /**
     * Gets the number of packets received for the physical network adapter.
     * 
     * @return the number of packets received for the physical network adapter
     */
    public Long getPacketsRx() {
        return this.packetsRx;
    }

    /**
     * Sets the number of packets received for the physical network adapter.
     * 
     * @param packetsRx - the number of packets received for the physical network adapter to set
     */
    public void setPacketsRx(Long packetsRx) {
        this.packetsRx = packetsRx;
    }

    /**
     * Gets the number of samples for the number of packets received for the physical network adapter.
     * 
     * @return the number of samples for the number of packets received for the physical network adapter
     */
    public Integer getNumSamplesPacketsRx() {
        return this.numSamplesPacketsRx;
    }

    /**
     * Sets the number of samples for the number of packets received for the physical network adapter.
     * 
     * @param numSamplesPacketsRx - the number of samples for the number of packets received for the physical network adapter to set
     */
    public void setNumSamplesPacketsRx(Integer numSamplesPacketsRx) {
        this.numSamplesPacketsRx = numSamplesPacketsRx;
    }
}
