/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;


import com.netapp.collectors.vmware.exceptions.VMWareConfigurationException;
import com.netapp.collectors.vmware.exceptions.VMWareServiceException;
import com.netapp.collectors.vmware.logger.LogsManager;
import org.slf4j.Logger;

/**
 * Factory to return different VMWare API services.
 * 
 * @author slaplante, dhetti
 */
public class VMWareServiceFactory {

    private static String CSV_URL = ".rawdata";
    private static String SDK_URL = "sdk";
    private static String VIM_SERVICE_URL = "vimService";
    /** Logger. */
    private static final Logger logger = LogsManager.getLogger(VMWareServiceFactory.class);
    
    /**
     * Creates a VMWare Service object appropriate for the api version at the given url.
     * 
     * @param url url of the vmware device
     * @return vmwareService VMWare service object
     */
    public static IVMWareService getVMWareService(String url) {
        // This is to use vmware raw csv stat file to replay stat collection, for testing / debugging only.
        if (url.endsWith(CSV_URL)) {
                return VMWare25CsvService.getInstance(); //TODO CSV was the old way of keeping the raw data, we probably wouldn't need this , but something with JSON probably is a better way of doing it
        } else if (url.endsWith(SDK_URL) || url.endsWith(VIM_SERVICE_URL)) {
            logger.info("Creating the vmware service for the url {} ", url);
            return VMWare25Service.getInstance();
        } else {
            logger.info("Unable to create vmware service for the url {}, reason - invalid URL ", url);
            throw new VMWareConfigurationException("Invalid URL for connecting to VIM service of VCenter.");
        }

    }
    
}
