/*
 * Copyright (c) 2011 NetApp
 * All rights reserved
 */

package com.netapp.collectors.vmware;

/**
 * This is a helper class containing common objects/data used by the service helper classes.
 * 
 * @author mkahlke
 *
 */
public class VMWareServiceHelper {
    
    /** Performance query contains stale virtual machine statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_VIRTUAL_MACHINE = 
        "The performance query result contains a stale \"{0}\" statistic for virtual machine: {1} on host: {2}. Timestamp: {3}.";

    /** Performance query contains stale host server statistics. */
    public static final String MSG_PERF_QUERY_RESULT_CONTAINS_STALE_STAT_FOR_HOST_SERVER = 
        "The performance query result contains a stale \"{0}\" statistic for host server: {1}. Timestamp: {2}.";

    /** Negative sample value. */
    public static final String MSG_SKIPPING_SAMPLE_DUE_TO_NEGATIVE_VALUE =
        "Negative {0} sample at index {1} returned for {2} : val={3}";

    /** Negative factor value. */
    public static final String MSG_SKIPPING_SAMPLE_DUE_TO_NEGATIVE_FACTOR =
        "Negative {0} factor at index {1} for {2} : val={3}";

    /** Sample value exceeds ceiling. */
    public static final String MSG_SKIPPING_SAMPLE_DUE_TO_CEILING_VIOLATION =
        "Invalid {0} sample at index {1} returned for {2} : val={3} > ceiling={4}";

    /** Sample value exceeds upper limit. */
    public static final String MSG_SKIPPING_SAMPLE_DUE_TO_UPPER_LIMIT_VIOLATION =
        "Invalid {0} sample at index {1} returned for {2} : val={3} > upperLimit={4}";

    /** paramMap keys */

    /** sum of valid counter samples (created/overwritten) */
    public static final String COUNTER_VALUE = "counterValue";

    /** number of valid counter samples (created/overwritten) */
    public static final String NUM_VALID_SAMPLES = "numValidSamples";

    /** raw samples (only populated if key passed in) */
    public static final String RAW_SAMPLE_VALUES = "rawSampleValues";

    /** per-sample multipliers (only used if passed in) */
    public static final String MULTIPLIERS = "multipliers";

    /** maximum value (only used if passed in) */
    public static final String UPPER_LIMIT = "upperLimit";

    /** values between ceiling and upperLimit are set to upperLimit (only if upperLimit is specified) */
    public static final String CEILING = "ceiling";

}
