/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

/**
 * Collection domain object for VMware Virtual Disks.
 * 
 * @author mkahlke
 *
 */
public class VMWareVirtualDisk {

    /** Managed object of this virtual machine. */
    private Object managedObject;
    
    private String scsiId;

    private Long readIOsAvg;

    private Long writeIOsAvg;

    private Long readDataAvg;

    private Long writeDataAvg;

    private Long readLatencyAvg;

    private Long writeLatencyAvg;

    private int numSamplesReadIOs;

    private int numSamplesWriteIOs;
    
    private int numSamplesReadData;
    
    private int numSamplesWriteData;

    private int numSamplesReadLatency;

    private int numSamplesWriteLatency;
    
    private String uuid;

    /**
     * Constructor.
     * 
     * @param managedObject managed object of this virtual disk
     */
    public VMWareVirtualDisk(Object managedObject) {
        this.managedObject = managedObject;
    }

    /**
     * Gets the managed object of this virtual machine.
     * 
     * @return managedObjectId managed object of this virtual disk
     */
    public Object getManagedObject() {
        return managedObject;
    }

    /**
     * Sets the managed object of this virtual machine.
     * 
     * @param managedObject managed object of this virtual disk
     */
    public void setManagedObject(Object managedObject) {
        this.managedObject = managedObject;
    }
    
    /**
     * Gets the scsiId of the virtual disk.
     * 
     * @return the scsiId of the virtual disk
     */
    public String getScsiId() {
        return this.scsiId;
    }

    /**
     * Sets the scsiId of the virtual disk.
     * 
     * @param scsiId the scsiId of the virtual disk to set
     */
    public void setScsiId(String scsiId) {
        this.scsiId = scsiId;
    }

    /**
     * Gets the average number of read IOs.
     * 
     * @return the average number of read IOs
     */
    public Long getReadIOsAvg() {
        return this.readIOsAvg;
    }

    /**
     * Sets the average number of read IOs.
     * 
     * @param readIOsAvg the average number of read IOs to set
     */
    public void setReadIOsAvg(Long readIOsAvg) {
        this.readIOsAvg = readIOsAvg;
    }

    /**
     * Gets the average number of write IOs.
     * 
     * @return the average number of write IOs
     */
    public Long getWriteIOsAvg() {
        return this.writeIOsAvg;
    }

    /**
     * Sets the average number of write IOs.
     * 
     * @param writeIOsAvg the average number of write IOs to set
     */
    public void setWriteIOsAvg(Long writeIOsAvg) {
        this.writeIOsAvg = writeIOsAvg;
    }

    /**
     * Gets the average number of bytes read.
     * 
     * @return the average number of bytes read
     */
    public Long getReadDataAvg() {
        return this.readDataAvg;
    }

    /**
     * Sets the average number of bytes read.
     * 
     * @param readDataAvg the average number of bytes read to set
     */
    public void setReadDataAvg(Long readDataAvg) {
        this.readDataAvg = readDataAvg;
    }

    /**
     * Gets the average number of bytes written.
     * 
     * @return the average number of bytes written
     */
    public Long getWriteDataAvg() {
        return this.writeDataAvg;
    }

    /**
     * Sets the average number of bytes written.
     * 
     * @param writeDataAvg the average number of bytes written to set
     */
    public void setWriteDataAvg(Long writeDataAvg) {
        this.writeDataAvg = writeDataAvg;
    }

    /**
     * Gets the average read latency.
     * 
     * @return the average read latency
     */
    public Long getReadLatencyAvg() {
        return this.readLatencyAvg;
    }

    /**
     * Sets the average read latency.
     * 
     * @param readLatencyAvg the average read latency to set
     */
    public void setReadLatencyAvg(Long readLatencyAvg) {
        this.readLatencyAvg = readLatencyAvg;
    }

    /**
     * Gets the average write latency.
     * 
     * @return the average write latency
     */
    public Long getWriteLatencyAvg() {
        return this.writeLatencyAvg;
    }

    /**
     * Sets the write average latency.
     * 
     * @param writeLatencyAvg the average write latency to set
     */
    public void setWriteLatencyAvg(Long writeLatencyAvg) {
        this.writeLatencyAvg = writeLatencyAvg;
    }

    /**
     * Gets the number of read IO samples.
     * 
     * @return the number of read IO samples
     */
    public int getNumSamplesReadIOs() {
        return this.numSamplesReadIOs;
    }

    /**
     * Sets the number of read IO samples.
     * 
     * @param numSamplesReadIOs the number of read IO samples to set
     */
    public void setNumSamplesReadIOs(int numSamplesReadIOs) {
        this.numSamplesReadIOs = numSamplesReadIOs;
    }

    /**
     * Gets the number of write IO samples.
     * 
     * @return the number of write IO samples
     */
    public int getNumSamplesWriteIOs() {
        return this.numSamplesWriteIOs;
    }

    /**
     * Sets the number of write IO samples.
     * 
     * @param numSamplesWriteIOs the number of write IO samples to set
     */
    public void setNumSamplesWriteIOs(int numSamplesWriteIOs) {
        this.numSamplesWriteIOs = numSamplesWriteIOs;
    }

    /**
     * Gets the number of read data samples.
     * 
     * @return the number of read data samples
     */
    public int getNumSamplesReadData() {
        return this.numSamplesReadData;
    }

    /**
     * Sets the number of read data samples.
     * 
     * @param numSamplesReadData the number of read data samples to set
     */
    public void setNumSamplesReadData(int numSamplesReadData) {
        this.numSamplesReadData = numSamplesReadData;
    }

    /**
     * Gets the number of write data samples.
     * 
     * @return the number of write data samples
     */
    public int getNumSamplesWriteData() {
        return this.numSamplesWriteData;
    }

    /**
     * Sets the number of write data samples.
     * 
     * @param numSamplesWriteData the number of write data samples to set
     */
    public void setNumSamplesWriteData(int numSamplesWriteData) {
        this.numSamplesWriteData = numSamplesWriteData;
    }

    /**
     * Gets the number of read latency samples.
     * 
     * @return the number of read latency samples
     */
    public int getNumSamplesReadLatency() {
        return this.numSamplesReadLatency;
    }

    /**
     * Sets the number of read latency samples.
     * 
     * @param numSamplesReadLatency the number of read latency samples to set
     */
    public void setNumSamplesReadLatency(int numSamplesReadLatency) {
        this.numSamplesReadLatency = numSamplesReadLatency;
    }

    /**
     * Gets the number of write latency samples.
     * 
     * @return the number of write latency samples
     */
    public int getNumSamplesWriteLatency() {
        return this.numSamplesWriteLatency;
    }

    /**
     * Sets the number of write latency samples.
     * 
     * @param numSamplesWriteLatency the number of write latency samples to set
     */
    public void setNumSamplesWriteLatency(int numSamplesWriteLatency) {
        this.numSamplesWriteLatency = numSamplesWriteLatency;
    }
    
    /**
     * Sets the UUID - Object ID of Virtual Disk from VCenter for Windows2012.
     * 
     * @param uuid the object id of virtual disk 
     */
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    /**
     * Gets the UUID - Object ID of Virtual Disk from VCenter for Windows2012.
     * 
     * @return uuid the object id of virtual disk
     */
    public String getUUID() {
        return this.uuid;
    }
    
}
