package com.netapp.collectors.vmware.exceptions;

/**
 * An enumerations of reasons the communicationState can be DOWN.
 *
 * If any new Communication State Reasons are added, it will also need to be added
 * to the discoverycommon.properties file.
 *
 * @author jbaboval
 */
public class CommunicationStateReason extends Enum {

    /**
     * generated serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * CommunicationStateReason constructor.
     * @param name The enum String
     * @param value the int value
     */
    private CommunicationStateReason(String name, int value){
        super(name, value);
    }

    /**
     * static method that returns a CommunicationStateReason enum given a name.
     * @param name The enum as a string
     * @return CommunicationStateReason
     */
    public static CommunicationStateReason getCommunicationStateReason(String name){
        CommunicationStateReason communicationStateReason = (CommunicationStateReason) get(name);
        if (communicationStateReason == null) {
            return null;

        }
        return communicationStateReason;
    }

    /**
     * get a CommunicationStateReason by passing in the int value.
     * @param value the int value of the enum
     * @return the CommunicationStateReason
     */
    public static CommunicationStateReason getCommunicationStateReason(int value) {
        CommunicationStateReason CommunicationStateReason = (CommunicationStateReason) get(value);
        if (CommunicationStateReason == null) {
            //TODO throw an error or just return null
            return null;
        }
        return CommunicationStateReason;
    }

    /**
     * get value.
     * @return the int value
     */
    public int getValue() {
        return value;
    }

    // If any new Communication State Reasons are added, it will also need to be added to the discoverycommon.properties file.

    /**
     * Some other reason; See CommunicationStateInfo.
     */
    public static final CommunicationStateReason OTHER = new CommunicationStateReason("OTHER", 0);

    /**
     * The access handle contained invalid data.
     */
    public static final CommunicationStateReason INVALID_CONFIGURATION = new CommunicationStateReason("INVALID_CONFIGURATION", 1);

    /**
     *  The collection server invoked an external application with invalid parameters.
     */

    public static final CommunicationStateReason INVALID_PARAMETERS = new CommunicationStateReason("INVALID_PARAMETERS", 2);

    /**
     *  The collection server could not read/write a temporary file.
     */
    public static final CommunicationStateReason FILE_ACCESS_ERROR = new CommunicationStateReason("FILE_ACCESS_ERROR", 3);

    /**
     * The connection to the device was refused.
     */
    public static final CommunicationStateReason CONNECTION_REFUSED = new CommunicationStateReason("CONNECTION_REFUSED", 4);

    /**
     * There was no route to the device.
     */
    public static final CommunicationStateReason NO_ROUTE_TO_HOST = new CommunicationStateReason("NO_ROUTE_TO_HOST", 5);

    /**
     * There was no route to the proxy.
     */
    public static final CommunicationStateReason PROXY_ERROR = new CommunicationStateReason("PROXY_ERROR", 6);

    /**
     * The primary credential was invalid.
     */
    public static final CommunicationStateReason INVALID_PRIMARY_CREDENTIAL = new CommunicationStateReason("INVALID_PRIMARY_CREDENTIAL", 7);

    /**
     * The secondary credential was invalid.
     */
    public static final CommunicationStateReason INVALID_SECONDARY_CREDENTIAL = new CommunicationStateReason("INVALID_SECONDARY_CREDENTIAL", 8);

    /**
     * The connection timed out.
     */
    public static final CommunicationStateReason TIMEOUT = new CommunicationStateReason("TIMEOUT", 9);

    /**
     * The device was not of the expected type.
     */
    public static final CommunicationStateReason INVALID_DEVICE_TYPE = new CommunicationStateReason("INVALID_DEVICE_TYPE", 10);

    /**
     * Unsupported proxy version.
     */
    public static final CommunicationStateReason UNSUPPORTED_VERSION = new CommunicationStateReason("UNSUPPORTED_VERSION", 11);

    /**
     * Incompatible proxy version.
     */
    public static final CommunicationStateReason INCOMPATIBLE_PROXY_VERSION = new CommunicationStateReason("INCOMPATIBLE_PROXY_VERSION", 12);

    /**
     * The collection server could not parse the collector output file.
     */
    public static final CommunicationStateReason PARSE_ERROR = new CommunicationStateReason("PARSE_ERROR", 13);

    /**
     * The collector thread pool of the quartz scheduler is full.
     */
    public static final CommunicationStateReason COLLECTOR_THREAD_POOL_SATURATED = new CommunicationStateReason("COLLECTOR_THREAD_POOL_SATURATED", 14);

    /**
     * The collection server could not execute commands successfully.
     */
    public static final CommunicationStateReason COMMAND_EXECUTION_FAILED = new CommunicationStateReason("COMMAND_EXECUTION_FAILED", 15);

    /**
     * Either connection refused or invalid credential error.
     */
    public static final  CommunicationStateReason AUTH_OR_CONNECT_FAILURE = new CommunicationStateReason("AUTH_OR_CONNECT_FAILURE", 16);

    /**
     * Long Running Collector.
     */
    public static final CommunicationStateReason LONG_RUNNING = new CommunicationStateReason("LONG_RUNNING", 17);

    /**
     * Device capability not found (mostly for Proxy based collections).
     */
    public static final CommunicationStateReason NOT_CAPABLE = new CommunicationStateReason("NOT_CAPABLE", 18);

    /**
     * Duplicate Resource.
     */
    public static final CommunicationStateReason DUPLICATE_RESOURCE = new CommunicationStateReason("DUPLICATE_RESOURCE", 19);

    /**
     * The IP address of a host could not be determined.
     */
    public static final CommunicationStateReason UNKNOWN_HOST = new CommunicationStateReason("UNKNOWN_HOST", 20);

    /**
     * This state reason is used for collection service failure when processing discovery collection
     * especially for integrity violations which are likely to be fixed the very next discovery.
     */
    public static final CommunicationStateReason PROCESSING_FAILURE = new CommunicationStateReason("PROCESSING_FAILURE", 21);

    /**
     * Name specified in the configuration was not found.
     */
    public static final CommunicationStateReason NAME_NOT_FOUND = new CommunicationStateReason("NAME_NOT_FOUND", 22);

    /**
     * Incomplete raw-data output file.
     */
    public static final CommunicationStateReason INCOMPLETE_RAWDATA_OUTPUT_FILE = new CommunicationStateReason("INCOMPLETE_RAWDATA_OUTPUT_FILE", 23);

    /**
     * Unauthorized execution of script file.
     */
    public static final CommunicationStateReason UNAUTHORIZED_SCRIPT_EXECUTION = new CommunicationStateReason("UNAUTHORIZED_SCRIPT_EXECUTION", 24);

    /**
     * Permission denied.
     */
    public static final CommunicationStateReason PERMISSION_DENIED = new CommunicationStateReason("PERMISSION_DENIED", 25);

    /**
     * This state reason is used when a requested network service is not found for a device.
     *
     * For Symmetrix devices, this is applicable when the value configured for the "SYMCLI_CONNECT" environment variable
     * does not match with a SYMAPI_SERVER configured in the "netcnfg" file on the Proxy.
     */
    public static final CommunicationStateReason SERVICE_NOT_FOUND = new CommunicationStateReason("SERVICE_NOT_FOUND", 26);

    /**
     * This state reason is used when a feature being requested is not currently licensed for a device.
     *
     * For Symmetrix devices, this is applicable when the SYMAPI_SERVER configured in the "netcnfg" file on the Proxy is
     * not currently licensed.
     */
    public static final CommunicationStateReason NOT_LICENSED = new CommunicationStateReason("NOT_LICENSED", 27);

    /**
     * Connection interrupted.
     */
    public static final CommunicationStateReason CONNECTION_INTERRUPTED = new CommunicationStateReason("CONNECTION_INTERRUPTED", 28);

    /**
     * This state reason is used when Balance had a heterogeneous license installed, and it expired.
     * When license expiration occurs, all non netapp storage devices will cease collection.
     */
    public static final CommunicationStateReason OUT_OF_COMPLIANCE_WITH_BALANCE_LICENSE = new CommunicationStateReason("OUT_OF_COMPLIANCE_WITH_BALANCE_LICENSE", 29);

    /**
     * If the device we are trying to communicate with uses HTTP and we get back a 503 (service unavailable), then
     * use this value.
     */
    public static final CommunicationStateReason HTTP_ACCESS_UNAVAILABLE = new CommunicationStateReason("HTTP_ACCESS_UNAVAILABLE", 30);

    /**
     * The connection to the device was refused.  Since this is a netapp array, we know that we have correctly
     * resolved the array, but we are getting a communication failure potentially due to the unsecure port
     * not being enabled.
     */
    public static final CommunicationStateReason NETAPP_CONNECTION_REFUSED = new CommunicationStateReason("NETAPP_CONNECTION_REFUSED", 31);

    /**
     * The error code occurs when the WMI service is paused.
     */
    public static final CommunicationStateReason WMI_SERVER_EXECUTION_FAILED = new CommunicationStateReason("WMI_SERVER_EXECUTION_FAILED", 32);

    /**
     * This error code occurs when the WMI service is disabled.
     */
    public static final CommunicationStateReason WMI_SERVICE_CANNOT_BE_STARTED = new CommunicationStateReason("WMI_SERVICE_CANNOT_BE_STARTED", 33);

    /**
     * This error code occurs when a class is found but corrupted or damaged; this usually occurs when there is a problem with the namespace.
     * The problem is corrected if the WMI counters are resync'd or the machine is rebooted.
     */
    public static final CommunicationStateReason WMI_INVALID_CLASS = new CommunicationStateReason("WMI_INVALID_CLASS", 34);

    /**
     * This error code occurs when an ORACLE database server throws a sql exception or a related exception which is communicated via
     * SQLException
     */
    public static final CommunicationStateReason COMMAND_EXECUTION_FAILED_ORA_ERROR = new CommunicationStateReason("COMMAND_EXECUTION_FAILED_ORA_ERROR", 35);

    /**
     * The error code occurs when the RPC server is unavailable.
     */
    public static final CommunicationStateReason RPC_SERVER_UNAVAILABLE = new CommunicationStateReason("RPC_SERVER_UNAVAILABLE", 36);

    /**
     * The error code occurs when a user does not enter a Cluster Management Interface.
     */
    public static final CommunicationStateReason NETAPP_NOT_MGMT_INTERFACE = new CommunicationStateReason("NETAPP_NOT_MGMT_INTERFACE", 37);

    /**
     *  The error code occurs when the insight_balance license on a NetApp controller has expired
     */
    public static final CommunicationStateReason LICENSE_EXPIRED = new CommunicationStateReason("LICENSE_EXPIRED", 38);

    /**
     *  The error code occurs when the insight_balance license on a NetApp controller is not found
     */
    public static final CommunicationStateReason NO_LICENSE_FOUND = new CommunicationStateReason("NO_LICENSE_FOUND", 39);

    // If any new Communication State Reasons are added, it will also need to be added to the discoverycommon.properties file.
}
