package com.netapp.collectors.vmware.exceptions;


/**
 * Exception which is thrown when something fails during certificate download.
 *
 * @author bsachin
 */
public class VMWareCertificateException extends RuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * Default constructor.
     */
    public VMWareCertificateException(){
        super();
    }

    /**
     * Constructor with a message string as the parameter.
     *
     * @param exceptionMessage The message to be displayed to the user.
     */
    public VMWareCertificateException(String exceptionMessage){
        super(exceptionMessage);
    }

    /**
     * Constructor.
     *
     * @param msg The custom message that should be added to this exception.
     * @param exception The exception that the Configuration exception wraps.
     */
    public VMWareCertificateException(String msg, Exception exception){
        super(msg,exception);
    }

}
