package com.netapp.collectors.vmware.exceptions;


import com.netapp.collectors.vmware.logger.LogsManager;
import org.slf4j.Logger;
/**
 * DeviceCommunication Exception.
 *
 * @author $author$
 * @version $Revision$
 */
public class VMWareConnectionException extends RuntimeException {

    /**
     * Gets logger on the package com.akorri.bp.collectionserver.
     */
    private static final transient Logger logger = LogsManager.getLogger(VMWareConnectionException.class);

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Communication state reason.
     */
    private CommunicationStateReason communicationStateReason;

    /**
     * DeviceCommunicationException.
     *
     * @param msg
     *            error message.
     */
    public VMWareConnectionException(String msg) {
        super(msg);
        this.communicationStateReason = CommunicationStateReason.OTHER;
        logger.error(msg);
    }

    /**
     * DeviceCommunicationException.
     *
     * @param e
     *            exception.
     */
    public VMWareConnectionException(Exception e) {
        super(e);
        this.communicationStateReason = CommunicationStateReason.OTHER;
//        logger.error(e, e);
    }

    /**
     * DeviceCommunicationException.
     *
     * @param msg
     *            msg.
     * @param e
     *            exception.
     */
    public VMWareConnectionException(String msg, Exception e) {
        super(msg, e);
        this.communicationStateReason = CommunicationStateReason.OTHER;
        logger.error(msg, e);
    }

    /**
     * Constructor with status and message arguments.
     *
     * @param communicationStateReason
     *            CommunicationStateReason.
     * @param msg
     *            message.
     */
    public VMWareConnectionException(CommunicationStateReason communicationStateReason, String msg) {
        super(msg);
        this.communicationStateReason = communicationStateReason;
    }

    /**
     * Constructor with throwable argument.
     *
     * @param communicationStateReason
     *            CommunicationStateReason.
     * @param t
     *            another exception.
     */
    private VMWareConnectionException(CommunicationStateReason communicationStateReason, Throwable t) {
        super(t);
        this.communicationStateReason = communicationStateReason;
        logger.error(t.getLocalizedMessage(), t);
    }

    /**
     * Constructor with Collection Status Type, throwable argument and message.
     *
     * @param communicationStateReason
     *            the communication state reason
     * @param t
     *            the throwable exception
     * @param msg
     *            the message
     */
    public VMWareConnectionException(CommunicationStateReason communicationStateReason, Throwable t,
                               String msg) {
        super(msg, t);
        this.communicationStateReason = communicationStateReason;
    }

    /**
     * Gets CommunicationStateReason.
     *
     * @return communicationStateReason.
     */
    public CommunicationStateReason getCommunicationStateReason() {
        return communicationStateReason;
    }

    /**
     * Set communicationStateReason.
     *
     * @param communicationStateReason
     *            Communication State Reason.
     */
    public void setCommunicationStateReason(CommunicationStateReason communicationStateReason) {
        this.communicationStateReason = communicationStateReason;
    }
}
