/*
 * Copyright (c) 2019 NetApp, Inc.
 * All rights reserved.
 */

package com.netapp.vmware.events;

import com.vmware.vim25.Event;

/**
 * Represents an event received from VMWare API. Contains the event which occurred and
 * the id of the access handle which the event occurred on.
 *
 * @author slaplante
 */
public interface IVMWareEvent {

	/**
	 * Gets an event which has been retrieved from the VMWare API.
	 *
	 * @return event event which has been retrieved from VMWare API
	 */
	Event getEvent();

	/**
	 * Sets an event which has been retrieved from the VMWare API.
	 *
	 * @param event event which has been retrieved from VMWare API
	 */
	void setEvent(Event event);


	/**
	 * Gets the id of the access handle which is the source of the event.
	 *
	 * @return sourceAccessHandleId id of the access handle which is the source of the event
	 */
	long getDatasourceId();

	/**
	 * Sets the id of the access handle which is the source of the event.
	 *
	 * @param sourceAccessHandleId id of the access handle which is the source of the event
	 */
	void setDatasourceId(long datasourceId);

}
