/*
 * Copyright (c) 2019 NetApp, Inc.
 * All rights reserved.
 */

package com.netapp.vmware.events;

import java.io.Serializable;

import com.vmware.vim25.Event;

/**
 * Represents an event received from VMWare API. This is passed to the
 * Virtual Center Event Processing Queue for the Virtual Center
 * Collection Service to handle.
 *
 * @author slaplante
 */
public class VMWareEvent implements IVMWareEvent, Serializable{

	/** Default serial version UID. */
	private static final long serialVersionUID = 1L;

	/** Event which has been received from VMWare API. */
	private Event event;

	/** Id of the data source which is the source of the event. */
	private long datasourceId;

	/**
	 * Constructor.
	 *
	 * @param event event which has been received from VMWare API.
	 * @param datasourceId id of the data source which is the source of the event
	 */
	public VMWareEvent(Event event, long datasourceId){
		this.event = event;
		this.datasourceId = datasourceId;
	}

	/** {@inheritDoc} */
	@Override
    public void setEvent(Event event) {
		this.event = event;
	}

	/** {@inheritDoc} */
	@Override
    public Event getEvent() {
		return this.event;
	}

	/** {@inheritDoc} */
	@Override
    public long getDatasourceId(){
		return this.datasourceId;
	}

	/** {@inheritDoc} */
	@Override
    public void setDatasourceId(long datasourceId){
		this.datasourceId = datasourceId;
	}

}
