/*
 * Copyright (c) 2020 NetApp, Inc. All rights reserved.
 *
 */
package com.onaro.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class AuProperties {

    private static Properties AuProperties;

    public static final String KEY_ACQUISITION_USER_PASSWORD= "acquisition.password";

    static {
        loadAuProperties();
    }

    public static Properties getAuProperties() {
        return AuProperties;
    }

    private static void loadAuProperties() {
        final String acqHomeDir = System.getProperty("acq.home");
        final String auPropsFile = acqHomeDir + File.separator + "conf" + File.separator + "preferences" + File.separator + "au.properties";
        AuProperties = new Properties();
        try {
            AuProperties.load(new FileInputStream(auPropsFile));
        } catch (IOException e) {
            throw new RuntimeException("Failed importing au properties file", e);
        }
    }
}