package com.onaro.commons.data.performance;

import java.io.Serializable;

/**
 * Used by the acquisition to report samples of a single object.
 */
public class RawSample<C> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The "key" identifing the object (e.g. WWN for port).
     */
    private String key;

    /**
     * The values recorded by the acquisition.
     */
    private C counters;

    public RawSample(String key, C counters) {
        setKey(key);
        setCounters(counters);
    }

    public RawSample() {
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public C getCounters() {
        return counters;
    }

    public void setCounters(C counters) {
        this.counters = counters;
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        RawSample rawSample = (RawSample) o;

        if (counters != null ? !counters.equals(rawSample.counters) : rawSample.counters != null)
            return false;
        if (!key.equals(rawSample.key))
            return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = key.hashCode();
        result = 31 * result + (counters != null ? counters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RawSample{" + "key='" + key + '\'' + ", counters=" + counters + '}';
    }
}
