package com.onaro.commons.executor;

import java.lang.management.ManagementFactory;

public class ElasticConfiguration {

    private static final long SYSTEM_PHYSICAL_MEMORY_GB = ((com.sun.management.OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / (1024 * 1024 * 1024);

    /**
     * noOfFoundationPollThreads
        memory   Fromformula  final
        4          29          30
        12         30          30
        16         31          31
        32         35          35
        60         41          41
        100        50          50
        150        61          60
        200        72          60
        250        83          60
        300        94          60
     */
    public static final int CALCULATED_FOUNDATIONPOLL_THREADS = (int) Math.ceil(.22 * SYSTEM_PHYSICAL_MEMORY_GB + 27.3);

    /**
     * noOfPerformancePollThreads
        memory   Fromformula  final
        4          29          30
        12         30          30
        16         31          31
        32         35          35
        60         41          41
        100        50          50
        150        61          60
        200        72          60
        250        83          60
        300        94          60
     */
    public static final int CALCULATED_PERFORMANCEPOLL_THREADS = (int) Math.ceil(.22 * SYSTEM_PHYSICAL_MEMORY_GB + 27.3);

    private ElasticConfiguration() {

    }

    /**
     * if min < calculatedThreads < max return max
     * if min < max < calculatedThreads return calculatedThreads
     * if calculatedThreads < min < max return max
     * @param min
     * @param max
     * @param calculatedThreads
     * @return
     */
    public static int getCount(int min, int max, int calculatedThreads) {
        return Math.max(Math.max(min, calculatedThreads), max);
    }

}
