/*
 * $Id: //depot/prod/acquisition/main/modules/commons-commons/src/main/java/com/onaro/commons/rest/RestConstants.java#1 $
 *
 * Copyright (c) 2020 NetApp, Inc.
 * All rights reserved.
 */
package com.onaro.commons.rest;

/**
 * @author skamath
 */
public class RestConstants {

    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String UTF_ENCODING = "utf-8";
    public static final String REQUEST_TYPE_POST = "POST";
    public static final String REQUEST_TYPE_GET = "GET";
    public static final String REQUEST_TYPE_DELETE = "DELETE";
    public static final String REQUEST_TYPE_PATCH = "PATCH";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONNECTION = "Connection";
    public static final String KEEP_ALIVE = "keep-alive";
    public static final String COOKIE = "Cookie";

    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String ACQUISITION_API = "/acquisition-api";
    public static final String FINISHED_SEND_DEBUG_MSG = "{} - Finished sending {} performance to server ({} msecs)";

    /*
     * Please maintain all the rest resource here for easy maintenance
     */

    public static final String PARAM                                    = "/server/param";

    public static final String WAFL_METRICS                             = "/ontap/metric/wafls/metrics";
    public static final String CLUSTER_METRICS                          = "/ontap/metric/clusters/metrics";
    public static final String FCP_PORT_METRICS                         = "/ontap/metric/fcp-ports/metrics";
    public static final String FCP_PORT_RAW_METRICS                     = "/ontap/metric/fcp-ports/raw-metrics";
    public static final String ISCSI_LIF_METRICS                        = "/ontap/metric/iscsi-lifs/metrics";
    public static final String ISCSI_LIF_RAW_METRICS                    = "/ontap/metric/iscsi-lifs/raw-metrics";
    public static final String ISCSI_LIF_VSERVER_METRICS                = "/ontap/metric/iscsi-lifs-vserver/metrics";
    public static final String ISCSI_LIF_VSERVER_RAW_METRICS            = "/ontap/metric/iscsi-lifs-vserver/raw-metrics";
    public static final String NETWORK_LIF_METRICS                      = "/ontap/metric/network-lif/metrics";
    public static final String NETWORK_LIF_RAW_METRICS                  = "/ontap/metric/network-lif/raw-metrics";
    public static final String NODE_METRICS                             = "/ontap/metric/nodes/metrics";
    public static final String NODE_RAW_METRICS                         = "/ontap/metric/nodes/raw-metrics";
    public static final String EXT_CACHE_METRICS                        = "/ontap/metric/ext-cache-objects/metrics";
    public static final String EXT_CACHE_RAW_METRICS                    = "/ontap/metric/ext-cache-objects/raw-metrics";
    public static final String DISK_METRICS                             = "/ontap/metric/disks/metrics";
    public static final String DISK_RAW_METRICS                         = "/ontap/metric/disks/raw-metrics";
    public static final String NFS_METRICS                              = "/ontap/metric/nfs/metrics";
    public static final String NFS_V3_METRICS                           = "/ontap/metric/nfsv3/metrics";
    public static final String NFS_V3_RAW_METRICS                       = "/ontap/metric/nfsv3/raw-metrics";
    public static final String NFS_V4_METRICS                           = "/ontap/metric/nfsv4/metrics";
    public static final String NFS_V4_RAW_METRICS                       = "/ontap/metric/nfsv4/raw-metrics";
    public static final String NFS_V41_METRICS                          = "/ontap/metric/nfsv41/metrics";
    public static final String NFS_V41_RAW_METRICS                      = "/ontap/metric/nfsv41/raw-metrics";
    public static final String NFS_V42_METRICS                          = "/ontap/metric/nfsv42/metrics";
    public static final String NFS_V42_RAW_METRICS                      = "/ontap/metric/nfsv42/raw-metrics";
    public static final String LUN_METRICS                              = "/ontap/metric/luns/metrics";
    public static final String LUN_METRICS_RAW                          = "/ontap/metric/luns/raw-metrics";
    public static final String CIFS_VSERVER_METRICS                     = "/ontap/metric/cifs-vservers/metrics";
    public static final String CIFS_VSERVER_METRICS_RAW                 = "/ontap/metric/cifs-vservers/raw-metrics";
    public static final String VSERVER_METRICS                          = "/ontap/metric/vservers/metrics";
    public static final String VOLUME_OBJECTSTORE_METRICS               = "/ontap/metric/volume-objectstores/metrics";
    public static final String NIC_METRICS                              = "/ontap/metric/nics/metrics";
    public static final String NIC_RAW_METRICS                          = "/ontap/metric/nics/raw-metrics";
    public static final String NVMFFC_METRICS                           = "/ontap/metric/nvmf-fc-lifs/metrics";
    public static final String NVMFFC_RAW_METRICS                       = "/ontap/metric/nvmf-fc-lifs/raw-metrics";
    public static final String NVMFFC_VSERVER_METRICS                   = "/ontap/metric/nvmf-fc-lifs-ververs/metrics";
    public static final String NVMFFC_VSERVER_RAW_METRICS               = "/ontap/metric/nvmf-fc-lifs-ververs/raw-metrics";
    public static final String NAMESPACE_METRICS                        = "/ontap/metric/namespaces/metrics";
    public static final String NAMESPACE_METRICS_RAW                    = "/ontap/metric/namespaces/raw-metrics";
    public static final String RESOURCE_HEADROOM_CPU_METRICS            = "/ontap/metric/resource-head-room-cpus/metrics";
    public static final String RESOURCE_HEADROOM_AGGR_METRICS           = "/ontap/metric/resource-head-room-aggregates/metrics";
    public static final String FCP_LIF_METRICS                          = "/ontap/metric/fcplifs/metrics";
    public static final String FCP_LIF_RAW_METRICS                      = "/ontap/metric/fcplifs/raw-metrics";
    public static final String FCP_LIF_VSERVER_METRICS                  = "/ontap/metric/fcp-lifs-vserver/metrics";
    public static final String FCP_LIF_VSERVER_METRICS_RAW              = "/ontap/metric/fcp-lifs-vserver/raw-metrics";
    public static final String QOS_FILE_METRICS                         = "/ontap/metric/qos/file-workloads/metrics";
    public static final String QOS_VOLUME_METRICS                       = "/ontap/metric/qos/volume-workloads/metrics";
    public static final String QOS_LUN_METRICS                          = "/ontap/metric/qos/lun-workloads/metrics";
    public static final String QOS_SERVICE_CENTER_METRICS               = "/ontap/metric/qos/service-centers/metrics";
    public static final String QOS_WORKLOAD_DETAILS_METRICS             = "/ontap/metric/qos/workload-details/metrics";
    public static final String QOS_WORKLOAD_QUEUE_DBLADE_METRICS        = "/ontap/metric/qos/workload-queue-dblades/metrics";
    public static final String QOS_WORKLOAD_QUEUE_NBLADE_METRICS        = "/ontap/metric/qos/workload-queue-nblades/metrics";
    public static final String OPM_HEAD_ROOM_CPU_METRICS                = "/ontap/metric/opm-head-room-cpus/metrics";
    public static final String OPM_HEAD_ROOM_AGGR_METRICS               = "/ontap/metric/opm-head-room-aggregates/metrics";


    public static final String PROCESSOR_METRICS                        = "/ontap/metric/processors/metrics";
    public static final String AGGR_OBJECT_METRICS                      = "/ontap/metric/aggr-object-stores/metrics";
    public static final String NETWORK_LIF_VSERVER_METRICS              = "/ontap/metric/network-lif-vservers/metrics";
    public static final String NETWORK_LIF_VSERVER_RAW_METRICS          = "/ontap/metric/network-lif-vservers/raw-metrics";

    public static final String AGGREGATE_METRICS                        = "/ontap/metric/aggregates/metrics";
    public static final String AGGREGATE_RAW_METRICS                    = "/ontap/metric/aggregates/raw-metrics";

    public static final String SUMMARY_SESSION_CODE_VERSION  = "/server/server-info/code-version";
    public static final String SUMMARY_SESSION_CODE_BUILD_NUMBER  = "/server/server-info/code-build-number";
    public static final String SUMMARY_SESSION_SITE_NAME  = "/server/server-info/site-name";
    public static final String SUMMARY_SESSION_DATABASE_VERSION  = "/server/server-info/database-version";
    public static final String SUMMARY_SESSION_CURRENT_TIME  = "/server/server-info/current-time";
    public static final String VMAWARE_VIRTUAL_DISKS  = "/vmaware/virtual-disks";
    public static final String VMAWARE_DATASTORES  = "/vmaware/datastores";
    public static final String VMAWARE_UUIDS  = "/vmaware/uuids";
    public static final String VMAWARE_HOST_DATASTORES  = "/vmaware/host-datastores";
    public static final String NAS_DATASTORE  = "/vmaware/nas-datastore";
    public static final String VMFS_DATASTORE  = "/vmaware/vmfs-datastore";

    public static final String ACQUISITION_FACADE_SESSION_ALL_DS = "/server/datasource/datasources";
    public static final String ACQUISITION_FACADE_SESSION_ALL_DS_NEW = "/server/datasource/datasources/new";
    public static final String ACQUISITION_FACADE_SESSION_DS_BY_ID = "/server/datasource/datasources";
    public static final String ID = "id";
    public static final String IDs = "ids";
    public static final String NAME = "name";
    public static final String FLAG = "flag";
    public static final String KEY = "key";
    public static final String URL = "url";
    public static final String AU_NAME = "au-name";
    public static final String SLASH_BRACED_ID = "/{" + ID + "}";
    public static final String SLASH_BRACED_KEY  = "/{" + KEY + "}";
    public static final String SLASH_BRACED_NAME = "/{" + NAME + "}";
    public static final String SLASH_BRACED_URL = "/{" + URL + "}";

    public static final String ACQUISITION_FACADE_SESSION_ORIGINITOR = "/server/originators";
    public static final String ACQUISITION_FACADE_SESSION_LATEST_PERFPOLL_TS = "/server/acquisition/performance-poll-info";
    public static final String ACQUISITION_FACADE_SESSION_FIND_ALL_DS_BY_VENDOR_MODELS = "/server/datasource/vendor-models";
    public static final String ACQUISITION_FACADE_SESSION_ACQ_UNITS= "/server/acquisition/units";
    public static final String ACQUISITION_FACADE_SESSION_ACQ_UNITS_BY_ID= "/server/acquisition/unitsById";

    public static final String ACQUISITION_FACADE_SESSION_RETIRE_EXPIRED_ORIGINITOR = "/server/originators/retire-expired";
    public static final String ACQUISITION_FACADE_SESSION_RETIRE_UNREPORTED_ORIGINATOR = "/server/originators/retired-unreported";
    public static final String ACQUISITION_FACADE_SESSION_ACQ_UNITS_DATASOURCES_DEPLOY= "/server/acquisition/datasources/deploy";



    /*
     * Please maintain all String representation of rest object here for easy maintenance
     * As of now please ensure there are no spaces in between
     *
     * For some we are appending "Remote" to be in sync with corresponding EJB
     *
     * TODO: check if this value can be used in both recordReportTime & log
     */

    public static final String WAFL                             = "Wafl";
    public static final String NETWORK_LIF                      = "NetworkLIF";
    public static final String NETWORK_LIF_RAW                  = "NetworkLIFRaw";
    public static final String EXT_CACHE                        = "ExtCache";
    public static final String EXT_CACHE_RAW                    = "ExtCacheRaw";
    public static final String DISK                             = "Disk";
    public static final String DISK_RAW                         = "DiskRaw";
    public static final String NFS                              = "Nfs";
    public static final String NFS_V3                           = "Nfsv3";
    public static final String NFS_V3_RAW                       = "Nfsv3Raw";
    public static final String NFS_V4                           = "Nfsv4";
    public static final String NFS_V4_RAW                       = "Nfsv4Raw";
    public static final String NFS_V41                          = "Nfsv41";
    public static final String NFS_V41_RAW                      = "Nfsv41Raw";
    public static final String NFS_V42                          = "Nfsv42";
    public static final String NFS_V42_RAW                      = "Nfsv42Raw";
    public static final String LUN                              = "Lun";
    public static final String CIFS_VSERVER                     = "CifsVserver";
    public static final String VSERVER                          = "Vserver";
    public static final String VOLUME_OBJSTORE                  = "VolumeObjectstore";
    public static final String FCP_PORT                         = "FcpPort";
    public static final String FCP_PORT_RAW                     = "FcpPortRaw";
    public static final String ISCSI_LIF                        = "IscsiLif";
    public static final String ISCSI_LIF_RAW                    = "IscsiLifRaw";
    public static final String NIC                              = "Nic";
    public static final String NIC_RAW                          = "NicRaw";
    public static final String NVMFFCLIF                        = "NvmfFcLif";
    public static final String NVMFFCLIF_RAW                    = "NvmfFcRawLif";
    public static final String NVMFFCVSERVER                    = "NvmfFcLifVserver";
    public static final String NVMFFCVSERVER_RAW                = "NvmfFcLifVserverRaw";
    public static final String NAMESPACE                        = "Namespace";
    public static final String NAMESPACE_RAW                    = "NamespacerRaw";
    public static final String RESOURCE_HEADROOM_CPU            = "ResourceHeadRoomCPU";
    public static final String RESOURCE_HEADROOM_AGGR           = "ResourceHeadRoomAggregate";
    public static final String ISCSI_LIF_VSERVER                = "IscsiLifVserver";
    public static final String ISCSI_LIF_VSERVER_RAW            = "IscsiLifVserverRaw";
    public static final String NODE                             = "Node";
    public static final String NODE_RAW                         = "NodeRaw";
    public static final String CLUSTER                          = "Cluster";
    public static final String FCP_LIF                          = "FcpLif";
    public static final String FCP_LIF_RAW                      = "FcpLifRaw";
    public static final String QOS_FILE                         = "QosFileWorkloadRemote";
    public static final String QOS_VOLUME                       = "QosVolumeWorkloadRemote";
    public static final String QOS_LUN                          = "QosLunWorkloadRemote";
    public static final String QOS_SERVICE_CENTER               = "QosServiceCenter";
    public static final String QOS_WORKLOAD_DETAILS             = "QosWorkloadDetails";
    public static final String QOS_WORKLOAD_QUEUE_DBLADE        = "QosWorkloadQueueDblade";
    public static final String QOS_WORKLOAD_QUEUE_NBLADE        = "QosWorkloadQueueNblade";
    public static final String FCP_LIF_VSERVER  = "FcpLifVserver";
    public static final String FCP_LIF_VSERVER_RAW  = "FcpLifVserverRaw";
    public static final String OPM_HEAD_ROOM_CPU                = "opmHeadroomCPU";
    public static final String OPM_HEAD_ROOM_AGGR               = "opmHeadroomAggr";

    public static final String PROCESSOR                        = "Processors";
    public static final String AGGR_OBJECT                      = "AggrObjectStore";
    public static final String NETWORK_LIF_VSERVER              = "NetworkLifVserver";
    public static final String NETWORK_LIF_VSERVER_RAW          = "NetworkLifVserverRaw";

    public static final String AGGREGATE                        = "Aggregate";
    public static final String AGGREGATE_RAW                    = "AggregateRaw";


    public static final String DATASOURCE                       = "datasource";
    public static final String DATASOURCES                      = "datasources";
    public static final String SERVER                           = "server";
    public static final String FORCE                            = "force";
    public static final String AUDITS                           = "audits";
    public static final String DATASOURCE_ID                    = "datasourceId";
    public static final String VCENTER_UUID                     = "vcenterUUID";
    public static final String WWN                              = "wwn";
    public static final String REMOTE_HOST                      = "remoteHost";
    public static final String PATH                             = "path";
    public static final String VENDOR_MODELS                    = "vendor-models";
    public static final String NOTIFICATIONS                    = "notifications";
    public static final String IS_RECONCILATION_RUNNING         = "isReconcilationRunning";
    public static final String OLD                              = "old";
    public static final String RESTART                          = "restart";
    public static final String MANUAL                           = "manual";
    public static final String INCLUDE_ATTRIBUTES               = "include-attributes";

    public static final String HISTORIES                        = "histories";

    public static final String SESSIONS                         = "sessions";
    public static final String SERVER_INFO                      = "server-info";
    public static final String SERVER_TIME                      = "server-time";
    public static final String SERVER_MESSAGES                  = "server-messages";
    public static final String STANDBY_REPORT                   = "standby-report";
    public static final String STOP_REPORT                      = "stop-report";
    public static final String ACQUISITION_UNITS                = "acquisition-units";

    public static final String PERFORMANCE_POLL_INFO            = "performance-poll-info";
    public static final String UNITS_BY_ID                      = "unitsById";
    public static final String PROPERTIES                       = "properties";
    public static final String DEFAULTS                         = "defaults";
    public static final String WAIT_FOR_DS_START                = "wait-for-ds-start";

    public static final String URL_DATASOURCE                   = "/" + DATASOURCE;
    public static final String URL_DATASOURCES                  = "/" + DATASOURCES;
    public static final String URL_SERVER                       = "/" + SERVER;
    public static final String URL_FORCE                        = "/" + FORCE;
    public static final String URL_AUDITS                       = "/" + AUDITS;
    public static final String URL_VENDOR_MODELS                = "/" + VENDOR_MODELS;
    public static final String URL_HISTORIES                    = "/" + HISTORIES;
    public static final String URL_NOTIFICATIONS                = "/" + NOTIFICATIONS;
    public static final String URL_RECONCILATION                = "/" + IS_RECONCILATION_RUNNING;

    public static final String URL_PERFORMANCE_POLL_INFO        = "/" + PERFORMANCE_POLL_INFO;

    public static final String URL_OLD                          = "/" + OLD;
    public static final String URL_NAME                         = "/" + NAME;
    public static final String URL_RESTART                      = "/" + RESTART;
    public static final String URL_MANUAL                       = "/" + MANUAL;
    public static final String URL_PROPERTIES                   = "/" + PROPERTIES;
    public static final String URL_DEFAULTS                     = "/" + DEFAULTS;
    public static final String URL_WAIT_FOR_DS_START            = "/" + WAIT_FOR_DS_START;


    public static final String VMAWARE                          = "vmaware";
    public static final String METRIC                           = "metric";
    public static final String VIRTUAL_DISKS                    = "virtual-disks";
    public static final String DATASTORES                       = "datastores";
    public static final String HOSTS                            = "hosts";
    public static final String HOST_DATASTORES                  = "host-datastores";

    public static final String URL_VMAWARE                      = "/" + VMAWARE;
    public static final String URL_METRIC                       = "/" + METRIC;
    public static final String URL_VIRTUAL_DISKS                = "/" + VIRTUAL_DISKS;
    public static final String URL_DATASTORES                   = "/" + DATASTORES;
    public static final String URL_HOSTS                        = "/" + HOSTS;
    public static final String URL_HOST_DATASTORES              = "/" + HOST_DATASTORES;

    public static final String URL_ACQUISITION_UNITS            = "/" + ACQUISITION_UNITS;
    public static final String URL_STANDBY_REPORT               = "/" + STANDBY_REPORT;
    public static final String URL_STOP_REPORT                  = "/" + STOP_REPORT;
    public static final String URL_SERVER_INFO                  = "/" + SERVER_INFO;
    public static final String URL_SERVER_TIME                  = "/" + SERVER_TIME;
    public static final String URL_SERVER_MESSAGES              = "/" + SERVER_MESSAGES;
    public static final String URL_SESSIONS                     = "/" + SESSIONS;
    public static final String URL_UNITS_BY_ID                  = "/" + UNITS_BY_ID;

    public static final String DEPLOY = "deploy";
    public static final String URL_DEPLOY = "/" + DEPLOY;
    public static final String STATUS = "status";
    public static final String ISACTIVE = "isActive";
    public static final String AUID = "auId";
    private static final String UPDATE_ACTIVE_STATE = "updateActiveState";
    public static final String URL_UPDATE_ACTIVE_STATE = "/" + UPDATE_ACTIVE_STATE;
    private static final String ACQUISITION_UNIT = "acquisition-unit";
    public static final String URL_ACQUISITION_UNIT = "/" + ACQUISITION_UNIT;
    private static final String UNREGISTER = "unregister" ;
    public static final String URL_UNREGISTER = "/" + UNREGISTER;
    private static final String RENEW_LEASE = "renewLease";
    public static final String URL_RENEW_LEASE = "/" + RENEW_LEASE;
    private static final String REPORT = "report";
    public static final String URL_REPORT = "/" + REPORT;
    private static final String REGISTER = "register" ;
    public static final String URL_REGISTER = "/" + REGISTER;
    public static final String RAW = "raw";
    public static final String URL_RAW = "/" + RAW;
    public static final String UNITS = "units";
    public static final String URL_UNITS = "/" +UNITS;






    private RestConstants() {
        // This is util so making the constructor private
    }

}
