package com.onaro.commons.types;


import java.util.Collection;

public class Period extends AbstractType {

    private static final long serialVersionUID = 1L;
    
	// the oreder of the id is   inportent for the query
    public final static Period SECOND = new Period(0, "SECOND", 1000, null);
    public final static Period MINUTE = new Period(1, "MINUTE", SECOND.milliseconds * 60, null);
    public final static Period HOUR = new Period(2, "HOUR", MINUTE.milliseconds * 60, MINUTE);
    public final static Period DAY = new Period(3, "DAY", HOUR.milliseconds * 24, HOUR);
    public final static Period WEEK = new Period(4, "WEEK", DAY.milliseconds * 7, DAY);
    public final static Period MONTH = new Period(5, "MONTH", DAY.milliseconds * 31, DAY);
    public final static Period YEAR = new Period(6, "YEAR", MONTH.milliseconds * 12, MONTH);


    private long milliseconds;
    private Period resolutionPeriod;

    private Period(int typeId, String name, long inMilliSeconds, Period resolutionPeriod) {
        super(Period.class, typeId, name);
        this.milliseconds = inMilliSeconds;
        this.resolutionPeriod = resolutionPeriod;
    }

    public static Period getById(int typeId) {
        return getById(Period.class, typeId);
    }

    public static Period getByName(String name) {
        return getByName(Period.class, name);
    }

    public static Period getByNameIgnoreCase(String name) {
        return getByNameIgnoreCase(Period.class, name);
    }

    /**
     * Gets a list of all the zone member types.
     *
     * @return a list of {@link AbstractType} objects
     */
    public static Collection<Period> getAll() {
        return getAll(Period.class);
    }

    public long milliseconds() {
        return milliseconds;
    }

    public long subtract(long time) {
        return time - milliseconds();
    }

    public long add(long time) {
        return time + milliseconds();
    }

    /**
     * @param time the time to substract from
     * @param count number of periods to subtract
     * @return for example for Period.DAY.subtract(System.currentTimeMillis(), 10) will return the currentTime - 10Days in MilliSeconds
     */
    public long subtract(long time, int count) {
        return time - count * milliseconds();
    }

    /**
     * @param time the time to add from
     * @param count number of periods to add
     * @return for example for Period.DAY.add(System.currentTimeMillis(), 10) will return the currentTime + 10Days in MilliSeconds
     */
    public long add(long time, int count) {
        return time + count * milliseconds();
    }



    public Period getResolutionPeriod() {
        return resolutionPeriod;
    }
}
