package com.onaro.commons.util;

import java.util.Comparator;

/**
 * Simple comparator that works against Comparable objects.
 *
 * @param <C> the Comparable object type
 */
public class ComparableComparator<C extends Comparable<C>> implements Comparator<C> {
    
    @SuppressWarnings("unchecked")
    private static final ComparableComparator INSTANCE = new ComparableComparator();
    
    /**
     * Get the untyped version of the ComparableComparator instance.
     * @param <C> the Comparable Class
     * @return the ComparableComparator instance.
     */
    @SuppressWarnings("unchecked")
    public static <C extends Comparable<C>> ComparableComparator<C> getInstance() {
        return (ComparableComparator<C>)INSTANCE;
    }
    
    /**
     * Get a typed version of the ComparableComparator instance.
     * @param <C> the Comparable Class
     * @param typeClass the Comparable class
     * @return the ComparableComparator typed to work on the class.
     */
    @SuppressWarnings("unchecked")
    public static <C extends Comparable<C>> ComparableComparator<C> getInstance(Class<C> typeClass) {
        return (ComparableComparator<C>)INSTANCE;
    }
    
    // No public constructor
    private ComparableComparator() {
    }

    public int compare(C o1, C o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        else if (o1 == null) {
            return -1;
        }
        else if (o2 == null) {
            return 1;
        }
        
        return o1.compareTo(o2);
    }
}
