package com.onaro.commons.util;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A very basic implementation of the least recently used cache map. Uses the LinkedHashMap with its access-order flag on
 * and set to remove eldest if the given capacity has been exceeded.<p/>
 *
 * @author Joshua Eisenthal
 */
public class LRUCacheMap<K,V> extends LinkedHashMap<K,V> {
    private final int capacity;

    public LRUCacheMap(int capacity) {
        super(capacity+1, 1.1f, true);
        this.capacity = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K,V> eldest) {
        return size() > capacity;    
    }
}
