package com.onaro.commons.util;

import java.util.Properties;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.beans.XMLEncoder;
import java.beans.XMLDecoder;

public class PropertiesEncoderHelper {

    static public String serializeProperties(Properties properties) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(baos);
            encoder.writeObject(properties);
            encoder.close();

            String result = new String(baos.toByteArray(), "utf-8");
            return result.replaceAll("[\\n\\r]", "");
        } catch (UnsupportedEncodingException e1) {
            //should not happen. utf-8 is supported
            return null;
        }
    }


    static public Properties deserializeProperties(String propsStr) {
        Properties props = null;
        try {
            if (propsStr != null) {
                XMLDecoder e = new XMLDecoder(new ByteArrayInputStream(propsStr.getBytes("utf-8")));
                props = (Properties) e.readObject();
                e.close();
            }
        } catch (UnsupportedEncodingException e) {
            //should not happen. utf-8 is supported
        }

        if (props == null) {
            props = new Properties();
        }

        return props;
    }
}
