package com.onaro.commons.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Resource
{

	/**
	 * The resource name, same as name field.
	 */
	String value() default ""; //$NON-NLS-1$
	
	/**
	 * The resource name, same as value field.
	 */
	String name() default ""; //$NON-NLS-1$
	
	/**
	 * Is the resource manager allowed to cache this resource.
	 */
	boolean cacheable() default true;
	
	/**
	 * If resource is not found and is NOT required, <code>null</code> is returned from get resource.
	 */
	boolean required() default true;
}
