package com.ontap.commons.data.dto;

import java.util.Collection;
import java.util.Objects;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.onaro.commons.data.performance.RawSample;

@JsonSerialize
public class NetappPerformanceDto<T> {
    private Long datasourceId;

    private String clusterKey;

    private String vServerKey;

    private long time;

    private Collection<RawSample<T>> samples;

    private long leaseTime;

    private boolean isHistorical;

    public NetappPerformanceDto() {
    }

    public Long getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(Long datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getClusterKey() {
        return clusterKey;
    }

    public void setClusterKey(String clusterKey) {
        this.clusterKey = clusterKey;
    }

    public String getvServerKey() {
        return vServerKey;
    }

    public void setvServerKey(String vServerKey) {
        this.vServerKey = vServerKey;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Collection<RawSample<T>> getSamples() {
        return samples;
    }

    public void setSamples(Collection<RawSample<T>> samples) {
        this.samples = samples;
    }

    public long getLeaseTime() {
        return leaseTime;
    }

    public void setLeaseTime(long leaseTime) {
        this.leaseTime = leaseTime;
    }

    public boolean isHistorical() {
        return isHistorical;
    }

    public void setHistorical(boolean historical) {
        isHistorical = historical;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetappPerformanceDto<?> that = (NetappPerformanceDto<?>) o;
        return time == that.time &&
                leaseTime == that.leaseTime &&
                isHistorical == that.isHistorical &&
                Objects.equals(datasourceId, that.datasourceId) &&
                Objects.equals(clusterKey, that.clusterKey) &&
                Objects.equals(vServerKey, that.vServerKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(datasourceId, clusterKey, vServerKey, time, leaseTime, isHistorical);
    }
}
