package com.vmware.commons.data.dto;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
public class VMwarePerformanceDto<T> {
    private Long datasourceId;

    private String vcenterKey;

    private List<T> samples;

    public VMwarePerformanceDto() {
    }

    public Long getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(Long datasourceId) {
        this.datasourceId = datasourceId;
    }

    public List<T> getSamples() {
        return samples;
    }

    public void setSamples(List<T> samples) {
        this.samples = samples;
    }

    public String getVcenterKey() {
        return vcenterKey;
    }

    public void setVcenterKey(String vcenterKey) {
        this.vcenterKey = vcenterKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VMwarePerformanceDto<?> that = (VMwarePerformanceDto<?>) o;
        return Objects.equals(datasourceId, that.datasourceId) &&
                Objects.equals(vcenterKey, that.vcenterKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(datasourceId, vcenterKey);
    }
}
