package com.netapp.oci.profiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * Profiles the size of the given directory.
 *
 * @author Shan Ponnusamy
 */
public class DirSizeProfiler implements Profiler {

    private File dir;
    private String profileItemName;

    public DirSizeProfiler(String profileItemName, File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this.dir = dir;
        this.profileItemName = profileItemName;
    }

    @Override
    public Map<String, Object> sample() {
        Map<String, Object> profileData = new HashMap<String, Object>();
        profileData.put(profileItemName, folderSize(dir));
        return profileData;
    }

    private long folderSize(File directory) {
        long length = 0;
        for (File file : directory.listFiles()) {
            if (file.isFile())
                length += file.length();
            else
                length += folderSize(file);
        }
        return length;
    }
}
