package com.netapp.oci.profiler;

import java.util.Map;

/**
 * A do-nothing profiler service.  Used when no profiler service is configured.
 *
 * @author Shan Ponnusamy
 */
public class NoOpProfilerService implements ProfilerService {

    @Override
    public void log(Map<String, Object> events) throws ProfilerServiceException {
        // intentionally left blank
    }

    @Override
    public void log(String event, Object value) throws ProfilerServiceException {
        // intentionally left blank
    }

    @Override
    public void start() {
        // intentionally left blank
    }

    @Override
    public void stop() {
        // intentionally left blank
    }

    @Override
    public boolean isEnabled() {
        return false;
    }
}
