package com.netapp.oci.profiler;

import java.io.IOException;
import java.util.Map;

/**
 * Data store for the profiler data.
 *
 * @author Shan Ponnusamy
 */
public interface ProfilerDataStore {

    /**
     * Store a bunch of profile data
     *
     * @param data          profile data
     * @throws IOException  if any issues arise during data storage.
     */
    void store(Map<String, Object> data) throws IOException;

    /**
     * Store a single profile item's value.
     * @param item          profiled item
     * @param value         profiled item's value
     * @throws IOException  if any issues arise during data storage.
     */
    void store(String item, Object value) throws IOException;

    /**
     * Close the data store for proper cleanup.
     * @throws IOException
     */
    void close() throws IOException;
}
