package com.netapp.oci.profiler;

import java.util.Map;

/**
 * @author Shan Ponnusamy
 */
public interface ProfilerService {
    /**
     * "Time" column header.
     */
    String TIME = "Time";

    /**
     * Start the profiler service.
     */
    void start();

    /**
     * Stop the profiler service, doing cleanup if necessary
     */
    void stop();

    /**
     * Used to check whether the profiling service is enabled.  Can be used to avoid complex calculations/wasted effort, if the
     * profiling service is not even enabled.
     *
     * @return <code>true</code>, if enabled.  Else, <code>false</code>.
     */
    boolean isEnabled();

    /**
     * Log a bunch of profiled items and their values to the profiler service.
     *
     * @param data                      data
     * @throws ProfilerServiceException if there was an unexpected error.
     */
    void log(Map<String, Object> data) throws ProfilerServiceException;

    /**
     * Log a single profiled item and its value to the profiler service.
     *
     * @param profiledItem                  profiled item
     * @param value                         profiled item's value.
     * @throws ProfilerServiceException     if there was an unexpected error.
     */
    void log(String profiledItem, Object value) throws ProfilerServiceException;
}
