/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.impl.logging;

import com.blackducksoftware.sdk.impl.logging.LoggingMessageSecure;

public class LoggingMessageStripWsse
extends LoggingMessageSecure {
    private static final String WSSE_SECURITY_HEADER_BEGIN_TAG = "<wsse:Security";
    private static final char END_OF_TAG = '>';
    private static final char EMPTY_TAG = '/';
    private static final String WSSE_SECURITY_HEADER_END_TAG = "</wsse:Security>";

    public LoggingMessageStripWsse(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected StringBuilder formatPayload(StringBuilder stringBuilder) {
        return this.filterWsseSecurity(this.getPayload());
    }

    private StringBuilder filterWsseSecurity(StringBuilder stringBuilder) {
        int n = stringBuilder.indexOf(WSSE_SECURITY_HEADER_BEGIN_TAG);
        if (n > 0) {
            int n2 = n + WSSE_SECURITY_HEADER_BEGIN_TAG.length() - 1;
            boolean bl = false;
            while (++n2 < stringBuilder.length()) {
                if (stringBuilder.charAt(n2) != '>') continue;
                if (stringBuilder.charAt(n2 - 1) != '/') break;
                bl = true;
                break;
            }
            if (!bl) {
                int n3 = stringBuilder.indexOf(WSSE_SECURITY_HEADER_END_TAG, n2);
                return stringBuilder.replace(n2 + 1, n3, "...");
            }
        }
        return stringBuilder;
    }
}

