/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaProxyFailedException;
import netapp.manage.NaServer;

public class NaProxyServer
extends NaServer {
    private String _target;
    private String _username;

    public NaProxyServer(InetAddress inetAddress, String string) {
        super(inetAddress);
        this.setProxyTarget(string);
    }

    public NaProxyServer(String string, String string2) throws UnknownHostException {
        this(InetAddress.getByName(string), string2);
    }

    public void setProxyTarget(String string) {
        if (null == string) {
            throw new IllegalArgumentException("target cannot be null");
        }
        this._target = string;
    }

    public void setProxyUsername(String string) {
        this._username = string;
    }

    @Override
    public NaElement invokeElem(NaElement naElement) throws IOException, NaAuthenticationException, NaProxyFailedException, NaAPIFailedException, NaProtocolException {
        int n;
        NaElement naElement2;
        NaElement naElement3 = new NaElement("api-proxy");
        naElement3.addNewChild("target", this._target);
        NaElement naElement4 = new NaElement("request");
        naElement3.addChildElem(naElement4);
        naElement4.addNewChild("name", naElement.getName());
        List list = naElement.getChildren();
        if (0 != list.size()) {
            naElement2 = new NaElement("args");
            naElement4.addChildElem(naElement2);
            for (NaElement naElement5 : list) {
                naElement2.addChildElem(naElement5);
            }
        }
        try {
            naElement2 = super.invokeElem(naElement3);
        }
        catch (NaAPIFailedException naAPIFailedException) {
            throw new NaProxyFailedException(naAPIFailedException.getErrno(), naAPIFailedException.getReason());
        }
        NaElement naElement6 = naElement2.getChildByName("response");
        if (null == naElement6) {
            throw new NaProtocolException("Missing proxy reponse");
        }
        if ("passed".equals(naElement6.getChildContent("status"))) {
            NaElement naElement5;
            naElement5 = naElement6.getChildByName("results");
            if (null == naElement5) {
                throw new NaProtocolException("Missing proxy results");
            }
            return naElement5;
        }
        String string = naElement6.getChildContent("errno");
        if (null == string) {
            throw new NaProtocolException("Missing errno in proxy response");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NaProtocolException("Malformed errno code: " + string, numberFormatException);
        }
        String string2 = naElement6.getChildContent("reason");
        if (null == string2) {
            throw new NaProtocolException("Missing reason in proxy response");
        }
        throw new NaAPIFailedException(n, string2);
    }
}

