/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import netapp.manage.NaCertificateException;
import netapp.manage.http.AuthInfo;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPRequest;
import netapp.manage.http.HTTPResponse;
import sun.security.util.HostnameChecker;

public class HTTPClient {
    private static final long TIMEOUT = 30000L;
    private static Object _lock = new Object();
    private static SocketFactory _plainFactory = SocketFactory.getDefault();
    private SocketFactory _sslFactory;
    private static SocketFactory _defaultSSLFactory = null;
    private boolean _useTLS = false;
    private boolean _useSSL = false;
    public static int snoop = 0;
    private boolean _ssl;
    private InetAddress _host;
    private int _port;
    private Socket _sock;
    private OutputStream _out;
    private InputStream _in;
    private int _useCount;
    private long _lastTimeUsed;
    private int _timeOut;
    private AuthInfo _authInfo;

    private static SocketFactory makeSSLFactory(AuthInfo authInfo) throws GeneralSecurityException, IOException {
        SSLSocketFactory sSLSocketFactory = null;
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = null;
        boolean bl = true;
        try {
            if (authInfo != null && (authInfo.isCBAEnabled() || authInfo.isServerCertVerificationEnabled())) {
                bl = false;
            }
            if (bl && _defaultSSLFactory != null) {
                return _defaultSSLFactory;
            }
            if (authInfo != null && authInfo.isCBAEnabled() && authInfo.getKeyStoreFile() != null) {
                keyManagerArray = HTTPClient.getKeyManagers(authInfo);
            }
            trustManagerArray = authInfo != null && authInfo.isServerCertVerificationEnabled() ? HTTPClient.getTrustManagers(authInfo) : HTTPClient.getDefaultTrustManagers();
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            sSLSocketFactory = sSLContext.getSocketFactory();
            if (bl) {
                _defaultSSLFactory = sSLSocketFactory;
            }
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw generalSecurityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private static X509TrustManager[] getDefaultTrustManagers() {
        X509TrustManager[] x509TrustManagerArray = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        return x509TrustManagerArray;
    }

    private static X509TrustManager[] getTrustManagers(AuthInfo authInfo) throws GeneralSecurityException, IOException {
        X509TrustManager[] x509TrustManagerArray = new X509TrustManager[]{new CustomX509TrustManager(authInfo)};
        return x509TrustManagerArray;
    }

    private static KeyManager[] getKeyManagers(AuthInfo authInfo) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagerArray = null;
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = null;){
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            fileInputStream = new FileInputStream(authInfo.getKeyStoreFile());
            keyStore = KeyStore.getInstance(authInfo.getKeyStoreType());
            keyStore.load(fileInputStream, authInfo.getKeyStorePasswd() != null ? authInfo.getKeyStorePasswd().toCharArray() : null);
            fileInputStream.close();
            keyManagerFactory.init(keyStore, authInfo.getKeyPasswd() != null ? authInfo.getKeyPasswd().toCharArray() : null);
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        return keyManagerArray;
    }

    public HTTPClient(boolean bl, String string, int n) throws IOException, UnknownHostException {
        this(bl, string, n, false);
    }

    public HTTPClient(boolean bl, String string, int n, boolean bl2) throws IOException, UnknownHostException {
        this(bl, InetAddress.getByName(string), n, bl2, 0, null, false);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n) throws IOException {
        this(bl, inetAddress, n, false, 0, null, false);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2) throws IOException {
        this(bl, inetAddress, n, bl2, 0, null, false);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2, int n2) throws IOException, SocketTimeoutException, IllegalArgumentException, IllegalBlockingModeException {
        this(bl, inetAddress, n, bl2, n2, null, false);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2, int n2, AuthInfo authInfo) throws IOException, SocketTimeoutException, IllegalArgumentException, IllegalBlockingModeException {
        this(bl, inetAddress, n, bl2, n2, authInfo, false);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2, int n2, AuthInfo authInfo, boolean bl3) throws IOException, SocketTimeoutException, IllegalArgumentException, IllegalBlockingModeException {
        this(bl, inetAddress, n, bl2, n2, authInfo, bl3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2, int n2, AuthInfo authInfo, boolean bl3, boolean bl4) throws IOException, SocketTimeoutException, IllegalArgumentException, IllegalBlockingModeException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        String[] stringArray;
        this._useTLS = bl3;
        this._useSSL = bl4;
        this._ssl = bl;
        this._host = inetAddress;
        this._port = n;
        this._timeOut = n2 * 1000;
        this._authInfo = authInfo;
        if (this._ssl) {
            Object object = _lock;
            synchronized (object) {
                try {
                    this._sslFactory = HTTPClient.makeSSLFactory(authInfo);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw (IOException)new IOException(generalSecurityException.toString()).initCause(generalSecurityException);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            if (this._timeOut > 0) {
                this._sock = this._sslFactory.createSocket();
                object = new InetSocketAddress(this._host, this._port);
                this._sock.connect((SocketAddress)object, this._timeOut);
                this._sock.setSoTimeout(this._timeOut);
            } else {
                this._sock = this._sslFactory.createSocket(this._host, this._port);
            }
        } else if (bl2) {
            int n3 = 1023;
            while (null == this._sock) {
                if (0 == n3) {
                    throw new IOException("Failed to bind to a reserved port");
                }
                try {
                    if (this._timeOut > 0) {
                        this._sock = _plainFactory.createSocket();
                        stringArray = new InetSocketAddress(this._host, this._port);
                        arrayList2 = null;
                        arrayList = new InetSocketAddress((InetAddress)((Object)arrayList2), n3);
                        this._sock.bind((SocketAddress)((Object)arrayList));
                        this._sock.connect((SocketAddress)stringArray, this._timeOut);
                        this._sock.setSoTimeout(this._timeOut);
                    } else {
                        this._sock = _plainFactory.createSocket(this._host, this._port, null, n3);
                    }
                }
                catch (BindException bindException) {
                    this._sock = null;
                }
                --n3;
            }
        } else if (this._timeOut > 0) {
            this._sock = _plainFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this._host, this._port);
            this._sock.connect(inetSocketAddress, this._timeOut);
            this._sock.setSoTimeout(this._timeOut);
        } else {
            this._sock = _plainFactory.createSocket(this._host, this._port);
        }
        if (this._sock instanceof SSLSocket) {
            String[] stringArray2;
            SSLSocket sSLSocket = (SSLSocket)this._sock;
            stringArray = sSLSocket.getEnabledProtocols();
            arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
            if (!this._useSSL) {
                arrayList2.remove("SSLv3");
            }
            if (!this._useTLS) {
                arrayList = arrayList2.iterator();
                while (arrayList.hasNext()) {
                    stringArray2 = (String[])arrayList.next();
                    if (stringArray2.indexOf("TLS") == -1) continue;
                    arrayList.remove();
                }
            }
            arrayList2.remove("SSLv2Hello");
            stringArray = arrayList2.toArray(new String[0]);
            sSLSocket.setEnabledProtocols(stringArray);
            arrayList = new ArrayList<String>();
            stringArray2 = sSLSocket.getEnabledCipherSuites();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].indexOf("MD5") != -1) continue;
                arrayList.add(stringArray2[i]);
            }
            stringArray2 = arrayList.toArray(new String[0]);
            sSLSocket.setEnabledCipherSuites(stringArray2);
        }
        this._out = this._sock.getOutputStream();
        this._in = this._sock.getInputStream();
        this._useCount = 0;
        this._lastTimeUsed = System.currentTimeMillis();
    }

    public void close() {
        try {
            this._out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this._in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this._sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isCompatible(boolean bl, String string, int n, AuthInfo authInfo) {
        return bl == this._ssl && string.equals(this._host.getHostName()) && n == this._port && AuthInfo.compare(this._authInfo, authInfo);
    }

    public boolean isCompatible(boolean bl, InetAddress inetAddress, int n, AuthInfo authInfo, boolean bl2) {
        return bl == this._ssl && inetAddress.equals(this._host) && n == this._port && AuthInfo.compare(this._authInfo, authInfo) && bl2 == this._useTLS;
    }

    public boolean isTimedOut() {
        return System.currentTimeMillis() > this._lastTimeUsed + 30000L;
    }

    public int getUseCount() {
        return this._useCount;
    }

    public void enableTLS() {
        this._useTLS = true;
    }

    public void disableTLS() {
        this._useTLS = false;
    }

    public boolean isTLSEnabled() {
        return this._useTLS;
    }

    public HTTPResponse doRequest(HTTPRequest hTTPRequest) throws IOException, HTTPException {
        hTTPRequest.setHeader("Host", this._host.getHostName() + (80 == this._port ? "" : ":" + this._port));
        hTTPRequest.write(this._out);
        HTTPResponse hTTPResponse = HTTPResponse.read(this._in);
        ++this._useCount;
        this._lastTimeUsed = System.currentTimeMillis();
        return hTTPResponse;
    }

    static class CustomX509TrustManager
    implements X509TrustManager {
        private X509TrustManager _trustManager = null;
        private String _hostNameOrIP;
        private boolean _isHostnameVerificationEnabled;
        private KeyStore _truststore;

        public CustomX509TrustManager(AuthInfo authInfo) throws GeneralSecurityException, IOException {
            FileInputStream fileInputStream = null;
            this._truststore = null;
            this._hostNameOrIP = authInfo.getHost();
            this._isHostnameVerificationEnabled = authInfo.isHostnameVerificationEnabled();
            try {
                Object object;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (authInfo.getTrustStoreFile() != null) {
                    fileInputStream = new FileInputStream(authInfo.getTrustStoreFile());
                    object = KeyStore.getInstance(authInfo.getTrustStoreType());
                    ((KeyStore)object).load(fileInputStream, null);
                    fileInputStream.close();
                    trustManagerFactory.init((KeyStore)object);
                    this._truststore = object;
                } else {
                    trustManagerFactory.init((KeyStore)null);
                }
                object = trustManagerFactory.getTrustManagers();
                for (int i = 0; i < ((TrustManager[])object).length; ++i) {
                    if (!(object[i] instanceof X509TrustManager)) continue;
                    this._trustManager = (X509TrustManager)object[i];
                    break;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw generalSecurityException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this._trustManager.checkClientTrusted(x509CertificateArray, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            X509Certificate x509Certificate = x509CertificateArray[0];
            try {
                this._trustManager.checkServerTrusted(x509CertificateArray, string);
                x509Certificate.checkValidity();
                if (!x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    if (this._truststore == null) {
                        object4 = null;
                        object3 = null;
                        object2 = System.getProperty("javax.net.ssl.trustStore");
                        if (object2 != null) {
                            object3 = new FileInputStream((String)object2);
                        } else {
                            object2 = System.getProperty("java.home") + "/lib/security/jssecacerts".replace('/', File.separatorChar);
                            object4 = new File((String)object2);
                            if (!((File)object4).exists()) {
                                object2 = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
                                object4 = new File((String)object2);
                            }
                            object3 = new FileInputStream((File)object4);
                        }
                        object = KeyStore.getInstance(KeyStore.getDefaultType());
                        try {
                            ((KeyStore)object).load((InputStream)object3, null);
                        }
                        finally {
                            ((FileInputStream)object3).close();
                        }
                        this._truststore = object;
                    }
                    object4 = new PKIXParameters(this._truststore);
                    ((PKIXParameters)object4).setRevocationEnabled(false);
                    object3 = CertificateFactory.getInstance("X.509");
                    object2 = ((CertificateFactory)object3).generateCertPath(Arrays.asList(x509CertificateArray));
                    object = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
                    ((CertPathValidator)object).validate((CertPath)object2, (CertPathParameters)object4);
                }
                if (this._isHostnameVerificationEnabled) {
                    HostnameChecker.getInstance((byte)1).match(this._hostNameOrIP, x509Certificate);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new NaCertificateException(x509CertificateArray, fileNotFoundException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                throw new NaCertificateException(x509CertificateArray, keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NaCertificateException(x509CertificateArray, noSuchAlgorithmException.getMessage());
            }
            catch (IOException iOException) {
                throw new NaCertificateException(x509CertificateArray, iOException.getMessage());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NaCertificateException(x509CertificateArray, invalidAlgorithmParameterException.getMessage());
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new NaCertificateException(x509CertificateArray, certPathValidatorException.getMessage());
            }
            catch (CertificateException certificateException) {
                String string2 = certificateException.getMessage();
                if (string2 != null && string2.equals("No subject alternative names present")) {
                    String string3 = x509Certificate.getSubjectX500Principal().getName();
                    String string4 = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        int n = string5.indexOf("CN=");
                        if (n < 0) continue;
                        int n2 = string5.indexOf(44, n + 3);
                        if (n2 == -1) {
                            n2 = string5.length();
                        }
                        string4 = string5.substring(n + 3, n2);
                        break;
                    }
                    if (this._hostNameOrIP.equalsIgnoreCase(string4)) {
                        return;
                    }
                    string2 = "Server certificate name (CN=" + string4 + "), hostname (" + this._hostNameOrIP + ") mismatch.";
                    throw new NaCertificateException(x509CertificateArray, string2);
                }
                throw new NaCertificateException(x509CertificateArray, string2);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this._trustManager.getAcceptedIssuers();
        }
    }
}

