/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.temporal;

import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration> {
    private final Long value;
    private final TimeUnit unit;

    private Duration(Long value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static Duration seconds(long seconds) {
        Duration.validate(seconds, TimeUnit.SECONDS);
        return new Duration(seconds, TimeUnit.SECONDS);
    }

    public static Duration millis(long millis) {
        Duration.validate(millis, TimeUnit.MILLISECONDS);
        return new Duration(millis, TimeUnit.MILLISECONDS);
    }

    public static Duration minutes(long minutes) {
        long seconds = minutes * 60L;
        Duration.validate(seconds, TimeUnit.SECONDS);
        return new Duration(seconds, TimeUnit.SECONDS);
    }

    public static Duration hours(long hours) {
        return Duration.minutes(hours * 60L);
    }

    public static Duration days(long days) {
        return Duration.hours(days * 24L);
    }

    private static void validate(long value, TimeUnit unit) {
        Duration duration = new Duration(value, unit);
        if (duration.inMillis() == Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
    }

    public long inMillis() {
        return this.unit.toMillis(this.value);
    }

    public long inSeconds() {
        return this.unit.toSeconds(this.value);
    }

    public long inMinutes() {
        return this.unit.toSeconds(this.value) / 60L;
    }

    public long inHours() {
        return this.inMinutes() / 60L;
    }

    public long inDays() {
        return this.inHours() / 24L;
    }

    public Duration plus(Duration duration) {
        return Duration.millis(duration.inMillis() + this.inMillis());
    }

    public Duration minus(Duration duration) {
        return Duration.millis(this.inMillis() - duration.inMillis());
    }

    public Boolean greaterThan(Duration duration) {
        return this.inMillis() > duration.inMillis();
    }

    public Boolean lessThan(Duration duration) {
        return this.inMillis() < duration.inMillis();
    }

    public int hashCode() {
        return new Long(this.unit.toMillis(this.value)).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().getName().equals(Duration.class.getName())) {
            return false;
        }
        Duration other = (Duration)o;
        return other.unit.toMillis(other.value) == this.unit.toMillis(this.value);
    }

    public String toString() {
        return "Duration " + this.value + " " + (Object)((Object)this.unit);
    }

    @Override
    public int compareTo(Duration other) {
        return this.value.compareTo(other.value);
    }
}

