/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.wnameless.json.base.JacksonJsonValue;
import com.github.wnameless.json.base.JsonObjectBase;
import com.github.wnameless.json.base.Jsonable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class JacksonJsonObject
implements JsonObjectBase<JacksonJsonValue>,
Jsonable {
    private final JsonNode jsonObject;

    public JacksonJsonObject(JsonNode jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public JacksonJsonValue get(String name) {
        return new JacksonJsonValue(this.jsonObject.get(name));
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((JacksonJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JacksonJsonValue>> iterator() {
        return new JacksonJsonEntryIterator(this.jsonObject.fields());
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    private final class JacksonJsonEntryIterator
    implements Iterator<Map.Entry<String, JacksonJsonValue>> {
        private final Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator;

        private JacksonJsonEntryIterator(Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator) {
            this.jsonNodeIterator = jsonNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonNodeIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JacksonJsonValue> next() {
            Map.Entry<String, JsonNode> member = this.jsonNodeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JacksonJsonValue>(member.getKey(), new JacksonJsonValue(member.getValue()));
        }
    }
}

