/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    static final transient Logger logger = LoggerFactory.getLogger("com.onaro.commons.exec");
    private String command;
    private File dir;
    private String[] envp;
    private int exitCode;
    private String error;
    private String output;
    private Exception exception;

    public Exec(String command) {
        this(command, null, null);
    }

    public Exec(String command, File dir) {
        this(command, dir, null);
    }

    public Exec(String command, File dir, String[] envp) {
        this.command = command;
        this.dir = dir;
        this.envp = envp;
    }

    public void run(long timout) {
        this.exception = null;
        this.output = null;
        this.error = null;
        this.exitCode = Integer.MIN_VALUE;
        ProcessOutputHandler stdout = new ProcessOutputHandler();
        ProcessOutputHandler stderr = new ProcessOutputHandler();
        try {
            final Process process = Runtime.getRuntime().exec(this.command, this.envp, this.dir);
            if (timout > -1L) {
                final long killTime = System.currentTimeMillis() + timout;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            try {
                                while (System.currentTimeMillis() < killTime && Exec.this.exitCode == Integer.MIN_VALUE) {
                                    Thread.sleep(1000L);
                                }
                                if (Exec.this.exitCode == Integer.MIN_VALUE) {
                                    logger.info("destroy process");
                                    process.destroy();
                                }
                            }
                            catch (InterruptedException e) {
                                if (Exec.this.exitCode != Integer.MIN_VALUE) break block4;
                                logger.info("destroy process", e);
                                process.destroy();
                            }
                        }
                    }
                }).start();
            }
            Thread currentThread = Thread.currentThread();
            stdout.start(currentThread, process.getInputStream(), "stdout");
            stderr.start(currentThread, process.getErrorStream(), "stderr");
            this.exitCode = process.waitFor();
            logger.debug("exitCode: " + this.exitCode);
        }
        catch (Exception e) {
            this.exception = e;
            this.error = "Failed to exec: " + this.command;
            logger.error("Failed to exec: " + this.command + " - " + e.getMessage(), e);
            return;
        }
        this.error = stderr.getOutput();
        this.output = stdout.getOutput();
        this.exception = stderr.exception;
        if (this.exception == null) {
            this.exception = stdout.exception;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getError() {
        return this.error;
    }

    public String getOutput() {
        return this.output;
    }

    public Exception getException() {
        return this.exception;
    }

    boolean isError() {
        return this.exception != null && this.error != null && this.error.length() > 0 && this.exitCode != Integer.MIN_VALUE;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("command missing line argument!");
        }
        String command = args[0];
        int timeout = 60000;
        if (args.length == 2) {
            timeout = Integer.parseInt(args[1]);
        }
        System.out.println("command:" + command);
        System.out.println("timeout:" + timeout);
        Exec exec = new Exec(command);
        exec.run(timeout);
    }

    class ProcessOutputHandler {
        LineNumberReader reader;
        StringBuilder output = new StringBuilder();
        Exception exception = null;
        Thread currentThread;
        String streamName;

        ProcessOutputHandler() {
        }

        public void start(Thread currentThread, InputStream in, String streamName) {
            try {
                this.currentThread = currentThread;
                this.reader = new LineNumberReader(new InputStreamReader(in));
                this.streamName = streamName;
            }
            catch (Exception e) {
                this.exception = e;
                this.output.append(streamName).append(" Failed to create LineNumberReader:").append(e.getMessage());
                logger.error(streamName + " Exception while execute " + Exec.this.command + " - " + e.getMessage(), e);
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.output.append(line).append(lineSeparator);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(streamName + ": " + line);
                }
                logger.debug(streamName + ": done");
            }
            catch (IOException e) {
                logger.error("Exception while execute " + Exec.this.command + " - " + e.getMessage(), e);
                this.exception = e;
                currentThread.interrupt();
            }
        }

        boolean getException() {
            return this.exception != null;
        }

        public String getOutput() {
            return this.output.toString();
        }
    }
}

