/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.exception.ConfigurationException;
import com.onaro.commons.framework.mgmt.CertificateDownloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpBasedUrlConnection {
    private static final Logger logger = LoggerFactory.getLogger(BasicHttpBasedUrlConnection.class);
    private static final String SERVER_PROPERTIES_KEY_FOR_TRUSTSTORE_PASSWORD = "truststore.password";
    private static final char[] DEFAULT_TRUSTSTORE_PASSWORD_VALUE = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private SSLSocketFactory sslSocketFactory = null;
    private String trustStorePath;
    private static BasicHttpBasedUrlConnection instance = new BasicHttpBasedUrlConnection();

    private BasicHttpBasedUrlConnection() {
    }

    public static BasicHttpBasedUrlConnection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSSL() throws ConfigurationException {
        String essentialsDir;
        if (logger.isDebugEnabled()) {
            logger.debug("HttpBasedUrlConnection - Initializing SSL");
        }
        if ((essentialsDir = System.getProperty("onaro.home")) == null) {
            throw new ConfigurationException("onaro.home system property not set!");
        }
        BasicHttpBasedUrlConnection basicHttpBasedUrlConnection = this;
        synchronized (basicHttpBasedUrlConnection) {
            this.trustStorePath = essentialsDir + "/jboss/server/onaro/cert/server.truststore";
            System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        this.loadCertificates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertificates() throws ConfigurationException {
        File trustStore = new File(this.trustStorePath);
        if (!trustStore.exists() || !trustStore.isFile()) {
            String defaultKeyStorePath = System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            if (logger.isDebugEnabled()) {
                logger.debug("HttpBasedUrlConnection - Copying default truststore from " + defaultKeyStorePath);
            }
            try {
                trustStore.getParentFile().mkdirs();
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(defaultKeyStorePath)));
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(trustStore));
                byte[] buffer = new byte[100000];
                try {
                    int l;
                    while ((l = ((InputStream)is).read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, l);
                    }
                }
                finally {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException l) {}
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException l) {}
                }
                String systemOS = System.getProperty("os.name");
                if (!systemOS.contains("Window")) {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(Paths.get(this.trustStorePath, new String[0]), perms);
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to copy default key store", e);
            }
        }
        CertificateDownloader downloader = new CertificateDownloader(this.trustStorePath);
        BasicHttpBasedUrlConnection basicHttpBasedUrlConnection = this;
        synchronized (basicHttpBasedUrlConnection) {
            this.sslSocketFactory = downloader.loadCertificates();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("HttpBasedUrlConnection - Loaded certificates!");
        }
    }

    public synchronized void downloadCertificate(URL url, int timeout, boolean override) throws ConfigurationException {
        this.downloadCertificate(url.getHost(), url.getPort(), timeout, override);
    }

    public synchronized void downloadCertificate(String host, int port, int timeout, boolean override) throws ConfigurationException {
        if (logger.isDebugEnabled()) {
            logger.debug("HttpBasedUrlConnection - Downloading certificate from host - " + host + ":" + port);
        }
        CertificateDownloader downloader = new CertificateDownloader(this.trustStorePath);
        downloader.downloadIfNeeded(host, port, timeout, override);
        this.sslSocketFactory = downloader.loadCertificates();
        HttpsURLConnection.setDefaultSSLSocketFactory(this.sslSocketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection openHttpConnection(URL url, int timeout, boolean checkCertificate) throws IOException, ConfigurationException {
        URLConnection urlConnection;
        if (logger.isDebugEnabled()) {
            logger.debug("HttpBasedUrlConnection - setting up http connection to url : " + url.toString());
        }
        if (!((urlConnection = url.openConnection()) instanceof HttpURLConnection)) {
            throw new ConfigurationException("Not http based url : " + url.toString());
        }
        if (urlConnection instanceof HttpsURLConnection) {
            if (logger.isDebugEnabled()) {
                logger.debug("HttpBasedUrlConnection - enabling SSL for url : " + url.toString());
            }
            if (null == this.sslSocketFactory || checkCertificate) {
                this.downloadCertificate(url, timeout, false);
            }
            BasicHttpBasedUrlConnection basicHttpBasedUrlConnection = this;
            synchronized (basicHttpBasedUrlConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
        }
        return (HttpURLConnection)urlConnection;
    }

    public synchronized SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public static String getServerTrustStorePassword() {
        Properties prop = new Properties();
        String serverPropertiesFilePath = System.getProperty("onaro.home", "/opt/netapp/essentials") + "/conf/server.properties";
        try {
            prop.load(new FileInputStream(serverPropertiesFilePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String password = prop.getProperty(SERVER_PROPERTIES_KEY_FOR_TRUSTSTORE_PASSWORD, String.copyValueOf(DEFAULT_TRUSTSTORE_PASSWORD_VALUE));
        return password;
    }

    static {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] existingMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(existingMethods));
            methodsSet.addAll(Arrays.asList("PATCH"));
            Object[] newMethodObjects = methodsSet.toArray();
            int size = newMethodObjects == null ? 0 : newMethodObjects.length;
            String[] newMethods = new String[size];
            if (newMethodObjects != null) {
                for (int i = 0; i < newMethodObjects.length; ++i) {
                    newMethods[i] = (String)newMethodObjects[i];
                }
            }
            methodsField.set(null, newMethods);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Runtime exception occured whie modifying HttpURLConnection to support PATCH method", e);
        }
    }
}

