/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.framework.mgmt.BasicHttpBasedUrlConnection;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CertificateDownload {
    private static final int MAX_RETRY_COUNT = 2;
    private static final Logger LOG = LoggerFactory.getLogger(CertificateDownload.class);
    private final String truststorePath;
    private final String truststorePassword;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public CertificateDownload(String truststorePath) {
        this(truststorePath, BasicHttpBasedUrlConnection.getServerTrustStorePassword());
    }

    public CertificateDownload(String truststorePath, String truststorePassword) {
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLSocketFactory downloadIfNeeded(String host, int port, int sslConnectionTimeout, boolean override) throws CertificateException {
        SSLSocketFactory sslSocketFactory = null;
        int retryCount = 1;
        while (retryCount <= 2) {
            KeyStore keyStore;
            try {
                if (port < 0) {
                    port = 443;
                }
                keyStore = this.loadKeyStore(this.truststorePath, this.truststorePassword);
                System.setProperty("javax.net.ssl.trustStore", this.truststorePath);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{tm}, null);
                sslSocketFactory = context.getSocketFactory();
                LOG.debug("Opening connection to {}:{}", (Object)host, (Object)port);
                socket.connect(new InetSocketAddress(host, port), sslConnectionTimeout);
                try (SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket();){
                    LOG.debug("Starting SSL handshake");
                    socket.startHandshake();
                    LOG.debug("No errors, certificate is already trusted");
                    if (!override || retryCount != 1) {
                        SSLSocketFactory sSLSocketFactory = sslSocketFactory;
                        return sSLSocketFactory;
                    }
                    LOG.info("Download and install certificate for IP {}", (Object)host);
                }
                ++retryCount;
                X509Certificate[] chain = tm.chain;
                if (chain == null) {
                    throw new CertificateException("Could not obtain server certificate chain from server " + host);
                }
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                for (int i = 0; i < chain.length; ++i) {
                    X509Certificate cert = chain[i];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("- {} Subject {}", (Object)(i + 1), (Object)cert.getSubjectDN());
                        LOG.debug("-   Issuer  {}", (Object)cert.getIssuerDN());
                        sha1.update(cert.getEncoded());
                        LOG.debug("-   SHA1    {}", (Object)CertificateDownload.toHexString(sha1.digest()));
                        md5.update(cert.getEncoded());
                        LOG.debug("-   MD5     {}", (Object)CertificateDownload.toHexString(md5.digest()));
                    }
                    String alias = "aiqum-vc-" + host + "-" + (i + 1);
                    keyStore.setCertificateEntry(alias, cert);
                    LOG.info("certificate was added to key store using alias: {}", (Object)alias);
                }
            }
            catch (IOException e) {
                throw new CertificateException(e.getMessage(), e);
            }
            catch (GeneralSecurityException gse) {
                throw new CertificateException("Failed to install certificate", gse);
            }
            this.writeToTrustStore(keyStore, this.truststorePath);
        }
        return sslSocketFactory;
    }

    private void writeToTrustStore(KeyStore keyStore, String truststorePath) throws CertificateException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(truststorePath);
            keyStore.store(out, this.truststorePassword.toCharArray());
        }
        catch (IOException ioe) {
            throw new CertificateException("Failed to save key store", ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new CertificateException("Failed to save key store", gse);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ignore) {
                    LOG.error("Failed to close the trustStore File");
                }
            }
        }
    }

    public void deleteCertificates(String alias) throws GeneralSecurityException, IOException {
        KeyStore keyStore = this.loadKeyStore(this.truststorePath, this.truststorePassword);
        if (alias != null) {
            LOG.info("Deleting vCenter certificate for alias: {}", (Object)alias);
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                LOG.info("Deleted certificates for alias: {}", (Object)alias);
                this.writeToTrustStore(keyStore, this.truststorePath);
            } else {
                LOG.info("Can't delete the certificate for alias [{}], as there is no entry for it in the trust store", (Object)alias);
            }
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String path, String password) throws GeneralSecurityException, IOException {
        FileInputStream fis = new FileInputStream(path);
        try {
            String type = KeyStore.getDefaultType();
            LOG.debug("loading {} w/ keystore.type={}", (Object)path, (Object)type);
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(fis, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

