/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.exception.ConfigurationException;
import com.onaro.commons.framework.mgmt.BasicHttpBasedUrlConnection;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CertificateDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateDownloader.class);
    private final String truststorePath;
    private final String truststorePassword;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public CertificateDownloader(String truststorePath) {
        this(truststorePath, BasicHttpBasedUrlConnection.getServerTrustStorePassword());
    }

    public CertificateDownloader(String truststorePath, String truststorePassword) {
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadIfNeeded(String host, int port, int timeout, boolean override) throws ConfigurationException {
        KeyStore serverTruststore;
        try {
            SavingTrustManager tm;
            block24: {
                if (port < 0) {
                    port = 443;
                }
                serverTruststore = this.loadKeyStore(this.truststorePath, this.truststorePassword);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(serverTruststore);
                X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                tm = new SavingTrustManager(defaultTrustManager);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory factory = context.getSocketFactory();
                LOG.debug("Opening connection to {}:{}", (Object)host, (Object)port);
                SSLSocket socket = (SSLSocket)factory.createSocket();
                socket.setSoTimeout(timeout);
                socket.connect(new InetSocketAddress(host, port), timeout);
                try {
                    LOG.debug("Starting SSL handshake");
                    socket.startHandshake();
                    LOG.debug("No errors, certificate is already trusted");
                    if (override) {
                        LOG.info("Download and install certificate for IP {}", (Object)host);
                        break block24;
                    }
                    return;
                }
                catch (SSLException ssle) {
                    LOG.info("Need to download and install certificate for IP {} [SSLException = {}]", (Object)host, (Object)ssle.getMessage());
                }
                finally {
                    socket.close();
                }
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                throw new ConfigurationException("Could not obtain server certificate chain from server " + host);
            }
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate cert = chain[i];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("- {} Subject {}", (Object)(i + 1), (Object)cert.getSubjectDN());
                    LOG.debug("-   Issuer  {}", (Object)cert.getIssuerDN());
                    sha1.update(cert.getEncoded());
                    LOG.debug("-   SHA1    {}", (Object)CertificateDownloader.toHexString(sha1.digest()));
                    md5.update(cert.getEncoded());
                    LOG.debug("-   MD5     {}", (Object)CertificateDownloader.toHexString(md5.digest()));
                }
                String alias = host + "-" + (i + 1);
                serverTruststore.setCertificateEntry(alias, cert);
                LOG.info("certificate was added to key store using alias '{}", (Object)alias);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (GeneralSecurityException gse) {
            throw new ConfigurationException("Failed to install certificate", gse);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.truststorePath);
            serverTruststore.store(out, this.truststorePassword.toCharArray());
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Failed to save key store", ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new ConfigurationException("Failed to save key store", gse);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SSLSocketFactory loadCertificates() throws ConfigurationException {
        LOG.debug("Loading certificates!");
        try {
            KeyStore trustkeyStore = this.loadKeyStore(this.truststorePath, this.truststorePassword);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustkeyStore);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{tm}, null);
            return context.getSocketFactory();
        }
        catch (GeneralSecurityException gse) {
            throw new ConfigurationException("Failed to load certificates", gse);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Failed to load certificates", ioe);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public Properties buildJdbcConnectionProps() {
        Properties jdbcProperties = new Properties();
        jdbcProperties.setProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
        jdbcProperties.setProperty("javax.net.ssl.trustStorePassword", this.truststorePassword);
        jdbcProperties.setProperty("javax.net.ssl.keyStorePassword", this.truststorePassword);
        jdbcProperties.put("javax.net.ssl.trustStore", this.truststorePath);
        jdbcProperties.put("javax.net.ssl.keyStore", this.truststorePath);
        return jdbcProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String path, String password) throws GeneralSecurityException, IOException {
        FileInputStream fis = new FileInputStream(path);
        try {
            String type = KeyStore.getDefaultType();
            LOG.debug("loading {} w/ keystore.type={}", (Object)path, (Object)type);
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(fis, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

