/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.framework.mgmt.CertificateDownload;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateDownloadingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateDownloadingService.class);
    private static CertificateDownloadingService instance = new CertificateDownloadingService();
    private CertificateDownload certificateDownloader;
    private String trustStorePath;

    private CertificateDownloadingService() {
        try {
            String essentialsDir = System.getProperty("onaro.home");
            if (essentialsDir == null) {
                throw new CertificateException("onaro.home system property not set!");
            }
            this.trustStorePath = essentialsDir + "/jboss/server/onaro/cert/server.truststore";
            this.certificateDownloader = new CertificateDownload(this.trustStorePath);
            System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
            this.loadCertificates();
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static CertificateDownloadingService getInstance() {
        return instance;
    }

    private void loadCertificates() throws CertificateException {
        File trustStore = new File(this.trustStorePath);
        if (!trustStore.exists() || !trustStore.isFile()) {
            String defaultKeyStorePath = System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("HttpBasedUrlConnection - Copying default truststore from " + defaultKeyStorePath);
            }
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(defaultKeyStorePath)));
                 BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(trustStore));){
                int l;
                trustStore.getParentFile().mkdirs();
                byte[] buffer = new byte[100000];
                while ((l = ((InputStream)is).read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, l);
                }
                String systemOS = System.getProperty("os.name").toLowerCase();
                if (!systemOS.contains("window")) {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(Paths.get(this.trustStorePath, new String[0]), perms);
                }
            }
            catch (IOException e) {
                throw new CertificateException("Failed to copy default key store", e);
            }
        }
    }

    public synchronized void downloadCertificates(URL url, int sslConnectionTimeout) throws CertificateException {
        if (!url.getProtocol().equalsIgnoreCase("HTTPS")) {
            throw new CertificateException("Not http based url : " + url.toString());
        }
        this.downloadCertificate(url, sslConnectionTimeout, false);
    }

    private void downloadCertificate(URL url, int sslConnectionTimeout, boolean override) throws CertificateException {
        SSLSocketFactory sslSocketFactory = this.certificateDownloader.downloadIfNeeded(url.getHost(), url.getPort(), sslConnectionTimeout, override);
        if (sslSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
        }
    }

    public synchronized void deleteCertificates(String alias) throws GeneralSecurityException, IOException {
        this.certificateDownloader.deleteCertificates(alias);
    }
}

