/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.exception.ConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPClientManager {
    private static final Logger logger = LoggerFactory.getLogger(HTTPClientManager.class);

    public JSONObject parse(HttpsURLConnection connResponse) throws IOException, ConfigurationException {
        int responseCode = connResponse.getResponseCode();
        String responseMessage = connResponse.getResponseMessage();
        String contentType = connResponse.getHeaderField("Content-Type");
        logger.debug(String.format("REST %s %s Response status : %d %s", connResponse.getURL().getProtocol(), connResponse.getURL().toString(), responseCode, responseMessage));
        JSONObject jsonObject = new JSONObject();
        InputStream is = null;
        is = responseCode >= 400 ? connResponse.getErrorStream() : connResponse.getInputStream();
        try {
            if (contentType != null && contentType.equalsIgnoreCase("application/json") && is != null && (jsonObject = (JSONObject)new JSONParser().parse(new InputStreamReader(is, StandardCharsets.UTF_8))) != null && responseCode >= 400) {
                String errorMessage = (String)jsonObject.get("message");
                throw new ConfigurationException(String.format("Error Response %d %s %s ", responseCode, responseMessage, errorMessage));
            }
        }
        catch (ParseException ex) {
            logger.error(String.format("Parse exception while reading REST response %s", ex.getMessage()));
            throw new ConfigurationException(ex.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return jsonObject;
    }

    public String buildResourcePath(String baseResourcePath, String pathParam, Map<String, String> requestParamMap) {
        return this.buildResourcePath(baseResourcePath, pathParam, null, requestParamMap);
    }

    public String buildResourcePath(String baseResourcePath, String pathParam, String extendedResourcePath, Map<String, String> requestParamMap) {
        StringBuilder sb = new StringBuilder(baseResourcePath);
        if (pathParam != null) {
            sb.append("/").append(pathParam);
        }
        if (extendedResourcePath != null) {
            if (extendedResourcePath.contains("/")) {
                sb.append(extendedResourcePath);
            } else {
                sb.append("/").append(extendedResourcePath);
            }
        }
        if (requestParamMap != null && !requestParamMap.isEmpty()) {
            sb.append("?");
            int i = 1;
            int requestParamMapSize = requestParamMap.size();
            for (Map.Entry<String, String> mapElement : requestParamMap.entrySet()) {
                String key = mapElement.getKey();
                String value = mapElement.getValue();
                if (key == null) continue;
                if (value == null) {
                    value = "";
                }
                String encodedRequestparam = URLEncoder.encode(value, StandardCharsets.UTF_8);
                sb.append(key + "=" + encodedRequestparam);
                if (++i > requestParamMapSize) continue;
                sb.append("&");
            }
        }
        return sb.toString();
    }

    public void logHTTPErrorStatus(int statusCode) throws ConfigurationException {
        StringBuilder builder = new StringBuilder();
        builder.append("Server returned HTTP status ").append(statusCode).append(".");
        logger.error(builder.toString());
        throw new ConfigurationException(builder.toString());
    }

    public void logHTTPErrorStatusWithMessage(InputStream stream, int statusCode) throws ConfigurationException {
        StringBuilder builder = new StringBuilder();
        String errorMessage = this.getErrorStringFromStream(stream);
        builder.append("Server returned HTTP status ").append(statusCode).append(".");
        builder.append("HTTP error message :").append(errorMessage);
        logger.error(builder.toString());
        throw new ConfigurationException(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorStringFromStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedReader streamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            streamReader = new BufferedReader(new InputStreamReader(stream));
            while ((line = streamReader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
        }
        catch (Exception ignore) {
        }
        finally {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (Exception ignore) {
                    logger.error("Error closing the stream: " + ignore.getMessage());
                }
            }
        }
        return stringBuilder.toString();
    }
}

