/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.onaro.commons.metrics.executor.ThreadPoolScope;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class MetricsRegistryProvider {
    private static final Object MUTEX = new Object();

    private MetricsRegistryProvider() {
    }

    private static void initRegistries() {
        MetricRegistry threadPoolMetricRegistry = SharedMetricRegistries.getOrCreate("threadPool");
        MetricsRegistryProvider.registerJVMMetrics(threadPoolMetricRegistry);
        MetricsRegistryProvider.registerCurrentTime(threadPoolMetricRegistry);
    }

    public static void registerJVMMetrics(MetricRegistry metricRegistry) {
        metricRegistry.register("jvm.fd_usage", new FileDescriptorRatioGauge());
        metricRegistry.register("jvm.thread-states", new ThreadStatesGaugeSet());
    }

    public static void registerCurrentTime(MetricRegistry metricRegistry) {
        metricRegistry.register("current.time", () -> System.currentTimeMillis());
    }

    public static MetricRegistry getMetricRegistry(String registryKey) {
        return SharedMetricRegistries.getOrCreate(registryKey);
    }

    public static Set<String> getMetricRegistryNames() {
        return SharedMetricRegistries.names();
    }

    public static <T extends Metric> T register(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey, T metric) {
        return metricRegistry.register(MetricRegistry.name(metricsPrefix, monitoringKey), metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Metric> T registerThreadPool(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey, T metric, ThreadPoolScope threadPoolScope) {
        String key = MetricRegistry.name(metricsPrefix, monitoringKey);
        Object object = MUTEX;
        synchronized (object) {
            if (threadPoolScope == ThreadPoolScope.METHOD) {
                metricRegistry.remove(key);
            }
            return metricRegistry.register(key, metric);
        }
    }

    public static void updateDurationTimer(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey, long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        Timer timer = MetricsRegistryProvider.timer(metricRegistry, metricsPrefix, monitoringKey);
        timer.update(duration, TimeUnit.MILLISECONDS);
    }

    public static Timer timer(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey) {
        return metricRegistry.timer(MetricRegistry.name(metricsPrefix, monitoringKey));
    }

    public static Histogram histogram(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey) {
        return metricRegistry.histogram(MetricRegistry.name(metricsPrefix, monitoringKey));
    }

    public static void clearAllMetrics(MetricRegistry metricRegistry) {
        for (String name : metricRegistry.getNames()) {
            metricRegistry.remove(name);
        }
    }

    public static String getGauge(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey) {
        return ((Gauge)metricRegistry.getGauges().get(MetricRegistry.name(metricsPrefix, monitoringKey))).getValue().toString();
    }

    public static void remove(MetricRegistry metricRegistry, String metricsPrefix, String monitoringKey) {
        metricRegistry.remove(MetricRegistry.name(metricsPrefix, monitoringKey));
    }

    static {
        MetricsRegistryProvider.initRegistries();
    }

    public static class RegistryKey {
        public static final String THREAD_POOL = "threadPool";
    }

    public static class ThreadPoolMonitoringKey {
        public static final String TASK_EXECUTION = "task-execution";
        public static final String TASK_QUEUE_WAIT_TIME = "task-queue-wait-time";
        public static final String CORE_POOL_SIZE = "corePoolSize";
        public static final String MAX_POOL_SIZE = "maxPoolSize";
        public static final String QUEUE_SIZE = "queueSize";
        public static final String ACTIVE_THREADS = "activeThreads";
        public static final String SUBMITTED_TASKS = "submittedTasks";
        public static final String COMPLETED_TASKS = "completedTasks";
        public static final String NOT_COMPLETED_TASKS = "notCompletedasks";
        public static final String PARALLELISM_LEVEL = "parallelismLevel";
        public static final String ASYNC_MODE = "asyncMode";
        public static final String STEAL_COUNT = "stealCount";
        public static final String THREAD_POOL_SCOPE = "threadPoolScope";
    }
}

