/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.metrics.executor;

import com.codahale.metrics.MetricRegistry;
import com.onaro.commons.metrics.MetricsRegistryProvider;
import com.onaro.commons.metrics.executor.ThreadPoolScope;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPoolMonitorExecutor
extends ForkJoinPool {
    private static final Logger errorLogger = LoggerFactory.getLogger(ForkJoinPoolMonitorExecutor.class);
    private static final MetricRegistry METRIC_REGISTRY = MetricsRegistryProvider.getMetricRegistry("threadPool");
    private final String metricsPrefix;
    private ThreadPoolScope threadPoolScope = ThreadPoolScope.GLOBAL;
    private final AtomicInteger submittedTasksCount = new AtomicInteger();

    public ForkJoinPoolMonitorExecutor(String poolName, ThreadPoolScope threadPoolScope) {
        super(Runtime.getRuntime().availableProcessors(), ForkJoinPoolMonitorExecutor.buildThreadFactory(poolName), null, false);
        this.metricsPrefix = MetricRegistry.name(this.getClass(), poolName);
        this.threadPoolScope = threadPoolScope;
        this.registerGauges(threadPoolScope);
    }

    public static ForkJoinPoolMonitorExecutor defaultForkJoinPoolExecutor(String poolName, ThreadPoolScope threadPoolScope) {
        return new ForkJoinPoolMonitorExecutor(poolName, threadPoolScope);
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory buildThreadFactory(final String poolName) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName(poolName + worker.getPoolIndex());
                return worker;
            }
        };
        return factory;
    }

    @Override
    public <T> T invoke(ForkJoinTask<T> task) {
        this.submittedTasksCount.incrementAndGet();
        return super.invoke(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        if (tasks != null) {
            tasks.forEach(t -> this.submittedTasksCount.incrementAndGet());
        }
        return super.invokeAll(tasks);
    }

    private void registerGauges(ThreadPoolScope threadPoolScope) {
        try {
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "corePoolSize", this::getPoolSize, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "parallelismLevel", this::getParallelism, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "queueSize", () -> this.getQueuedTaskCount() + (long)this.getQueuedSubmissionCount(), threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "activeThreads", this::getActiveThreadCount, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "asyncMode", this::getAsyncMode, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "stealCount", this::getStealCount, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "submittedTasks", () -> this.submittedTasksCount.get(), threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "threadPoolScope", () -> this.threadPoolScope.toString(), threadPoolScope);
        }
        catch (Exception e) {
            errorLogger.warn("Error while registering gauges ", e);
        }
    }
}

