/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.metrics.executor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.onaro.commons.metrics.MetricsRegistryProvider;
import com.onaro.commons.metrics.executor.ThreadPoolScope;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledThreadPoolMonitorExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger errorLogger = LoggerFactory.getLogger(ScheduledThreadPoolMonitorExecutor.class);
    private static final MetricRegistry METRIC_REGISTRY = MetricsRegistryProvider.getMetricRegistry("threadPool");
    private final String metricsPrefix;
    private ThreadPoolScope threadPoolScope = ThreadPoolScope.GLOBAL;
    protected ThreadLocal<Timer.Context> taskExecutionTimer = new ThreadLocal();
    protected ThreadLocal<Long> taskExeutionTime = new ThreadLocal();

    public ScheduledThreadPoolMonitorExecutor(int corePoolSize, String poolName, ThreadPoolScope threadPoolScope) {
        super(corePoolSize, new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build());
        this.metricsPrefix = MetricRegistry.name(this.getClass(), poolName);
        this.threadPoolScope = threadPoolScope;
        this.registerGauges(threadPoolScope);
    }

    public ScheduledThreadPoolMonitorExecutor(int corePoolSize, RejectedExecutionHandler handler, String poolName, ThreadPoolScope threadPoolScope) {
        super(corePoolSize, new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), handler);
        this.metricsPrefix = MetricRegistry.name(this.getClass(), poolName);
        this.threadPoolScope = threadPoolScope;
        this.registerGauges(threadPoolScope);
    }

    public static ScheduledThreadPoolMonitorExecutor newScheduledThreadPool(int poolSize, String poolName, ThreadPoolScope threadPoolScope) {
        return new ScheduledThreadPoolMonitorExecutor(poolSize, poolName, threadPoolScope);
    }

    public static ScheduledThreadPoolMonitorExecutor newSingleThreadScheduledExecutor(String poolName, ThreadPoolScope threadPoolScope) {
        return new ScheduledThreadPoolMonitorExecutor(1, poolName, threadPoolScope);
    }

    @Override
    public void execute(Runnable task) {
        long startTime = System.currentTimeMillis();
        super.execute(() -> {
            MetricsRegistryProvider.updateDurationTimer(METRIC_REGISTRY, this.metricsPrefix, "task-queue-wait-time", startTime);
            task.run();
        });
    }

    @Override
    public Future<?> submit(Runnable task) {
        long startTime = System.currentTimeMillis();
        return super.submit(() -> {
            MetricsRegistryProvider.updateDurationTimer(METRIC_REGISTRY, this.metricsPrefix, "task-queue-wait-time", startTime);
            task.run();
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        long startTime = System.currentTimeMillis();
        return super.submit(() -> {
            MetricsRegistryProvider.updateDurationTimer(METRIC_REGISTRY, this.metricsPrefix, "task-queue-wait-time", startTime);
            return task.call();
        });
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        super.beforeExecute(thread, task);
        Timer timer = MetricsRegistryProvider.timer(METRIC_REGISTRY, this.metricsPrefix, "task-execution");
        this.taskExecutionTimer.set(timer.time());
    }

    @Override
    protected void afterExecute(Runnable task, Throwable throwable) {
        Timer.Context context = this.taskExecutionTimer.get();
        long elapsed = context.stop();
        long elapsedTimeInSecond = elapsed / 1000000000L;
        this.taskExeutionTime.set(elapsedTimeInSecond);
        super.afterExecute(task, throwable);
    }

    private void registerGauges(ThreadPoolScope threadPoolScope) {
        try {
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "corePoolSize", this::getCorePoolSize, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "maxPoolSize", this::getMaximumPoolSize, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "queueSize", () -> this.getQueue().size(), threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "activeThreads", this::getActiveCount, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "completedTasks", this::getCompletedTaskCount, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "submittedTasks", this::getTaskCount, threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "notCompletedasks", () -> this.getTaskCount() - this.getCompletedTaskCount(), threadPoolScope);
            MetricsRegistryProvider.registerThreadPool(METRIC_REGISTRY, this.metricsPrefix, "threadPoolScope", () -> this.threadPoolScope.toString(), threadPoolScope);
        }
        catch (Exception e) {
            errorLogger.warn("Error while registering gauges ", e);
        }
    }
}

