/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.onaro.commons.exception.NetappInterfaceException;
import com.onaro.commons.util.HttpURLConnectionUtils;
import com.ontap.commons.data.dto.NetappPerformanceDto;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetAppPostPerformanceData {
    private static final Logger logger = LoggerFactory.getLogger(NetAppPostPerformanceData.class.getName());
    private static final String COOKIE_STRING = "Cookie";
    private static final String SESSION_STRING = "JSESSIONID=";
    private static String jSessionId = "";

    private NetAppPostPerformanceData() {
    }

    public static <T> void postNetappPerformanceData(HttpURLConnection urlConnection, String restResource, NetappPerformanceDto<T> netappPerformanceDto) throws NetappInterfaceException {
        OutputStreamWriter streamWriter = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.info("Sending  data to :" + urlConnection.getURL().toString());
            }
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json; utf-8");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setDoOutput(true);
            if (!jSessionId.isEmpty()) {
                urlConnection.setRequestProperty(COOKIE_STRING, jSessionId);
            }
            streamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), "utf-8");
            ObjectMapper mapper = new ObjectMapper();
            if (logger.isDebugEnabled()) {
                String jsonString = mapper.writeValueAsString(netappPerformanceDto);
                logger.debug("Size of samples in bytes: " + jsonString.length());
                logger.debug("Samples sent: " + jsonString);
            }
            mapper.writerWithDefaultPrettyPrinter().writeValue(streamWriter, netappPerformanceDto);
            String errorString = NetAppPostPerformanceData.getStringFromStream(urlConnection.getErrorStream());
            String inputString = NetAppPostPerformanceData.getStringFromStream(urlConnection.getInputStream());
            String statusMessage = urlConnection.getResponseMessage();
            int statusCode = urlConnection.getResponseCode();
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Status Code ").append(statusCode).append(" , status Message ").append(statusMessage).append(".");
                if (null != inputString) {
                    builder.append("Input String ").append(inputString).append(".");
                }
                if (null != errorString) {
                    builder.append("Error String ").append(errorString).append(".");
                }
                logger.debug(builder.toString());
            }
            String currJessionId = HttpURLConnectionUtils.getJsesionIdCookie(urlConnection);
            if (statusCode == 200 && currJessionId != null) {
                jSessionId = currJessionId;
            }
            if (statusCode < 200 || statusCode > 299) {
                StringBuilder builder = new StringBuilder();
                builder.append("Server returned HTTP status ").append(statusCode).append(".");
                if (errorString != null) {
                    builder.append("Error message received: ").append(errorString);
                }
                logger.error("Error while sending performance data to server:" + builder.toString());
                throw new RuntimeException(builder.toString());
            }
        }
        catch (Exception e) {
            logger.error("Error while sending performance data to server: " + e.getMessage());
            throw new NetappInterfaceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedReader streamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            streamReader = new BufferedReader(new InputStreamReader(stream));
            while ((line = streamReader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
        }
        catch (Exception ignore) {
        }
        finally {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (Exception ignore) {
                    logger.error("Error closing the stream: " + ignore.getMessage());
                }
            }
        }
        return stringBuilder.toString();
    }
}

