/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.rest;

import com.onaro.commons.exception.NetappInterfaceException;
import com.onaro.commons.framework.mgmt.AcquisitionHttpClientConnectionManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamUtil {
    public static final String PARAM_REST_URL = "/acquisition-api/server/param";
    private static final Logger LOG = LoggerFactory.getLogger(ParamUtil.class);
    private static final String queryParams = "/acquisition-api/server/param?paramName={0}&paramType={1}&defaultValue={2}";

    private ParamUtil() {
    }

    public static String get(String paramKey, String defaultValue) {
        String value = ParamUtil.getParam(paramKey, String.class.getSimpleName(), defaultValue);
        return value;
    }

    public static boolean get(String paramKey, boolean defaultValue) {
        String value = ParamUtil.getParam(paramKey, Boolean.TYPE.getSimpleName(), "" + defaultValue);
        return Boolean.parseBoolean(value);
    }

    public static int get(String paramKey, int defaultValue) {
        String value = ParamUtil.getParam(paramKey, Boolean.TYPE.getSimpleName(), "" + defaultValue);
        return Integer.parseInt(value);
    }

    public static long get(String paramKey, long defaultValue) {
        String value = ParamUtil.getParam(paramKey, Boolean.TYPE.getSimpleName(), "" + defaultValue);
        return Long.parseLong(value);
    }

    public static void set(String paramKey, String value) throws NetappInterfaceException {
        ParamUtil.saveParam(paramKey, String.class.getSimpleName(), value);
    }

    public static void set(String paramKey, boolean value) throws NetappInterfaceException {
        ParamUtil.saveParam(paramKey, Boolean.TYPE.getSimpleName(), "" + value);
    }

    public static void set(String paramKey, int value) throws NetappInterfaceException {
        ParamUtil.saveParam(paramKey, Integer.TYPE.getSimpleName(), "" + value);
    }

    public static void set(String paramKey, long value) throws NetappInterfaceException {
        ParamUtil.saveParam(paramKey, Long.TYPE.getSimpleName(), "" + value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getParam(String paramName, String paramType, String defautlValue) {
        try {
            String stringUrl = MessageFormat.format(queryParams, paramName, paramType, defautlValue);
            AcquisitionHttpClientConnectionManager acquisitionHttpClientConnectionManager = AcquisitionHttpClientConnectionManager.getInstance();
            HttpsURLConnection connection = acquisitionHttpClientConnectionManager.executeHTTPSGETAcquisitionAPI(stringUrl);
            int statusCode = connection.getResponseCode();
            if (statusCode == 200) {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String response = in.lines().collect(Collectors.joining());
                    LOG.debug("GET Response for param " + connection.getURL().toString() + " ", (Object)response);
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(response);
                    String string = (String)json.get("paramValue");
                    return string;
                }
                catch (IOException e) {
                    String errorMessage = " - Failed to get param " + e.getMessage();
                    LOG.error(errorMessage, e);
                    return defautlValue;
                }
            }
            if (statusCode >= 200) {
                if (statusCode <= 299) return defautlValue;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Server returned HTTP status ").append(statusCode).append(".");
            LOG.error(builder.toString());
            return defautlValue;
        }
        catch (Exception exceptionInstance) {
            String errorMessage = " - Failed to get param" + exceptionInstance.getMessage();
            LOG.error(errorMessage, exceptionInstance);
            return defautlValue;
        }
    }

    public static void saveParam(String paramName, String paramType, String paramValue) throws NetappInterfaceException {
        try {
            String resourceUrl = PARAM_REST_URL;
            AcquisitionHttpClientConnectionManager acquisitionHttpClientConnectionManager = AcquisitionHttpClientConnectionManager.getInstance();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("paramName", paramName);
            jsonObject.put("paramType", paramType);
            jsonObject.put("paramValue", paramValue);
            HttpsURLConnection connection = acquisitionHttpClientConnectionManager.executeHTTPSPOSTAcquisitionAPI(resourceUrl, jsonObject);
            int statusCode = connection.getResponseCode();
            if (statusCode == 200) {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String response = in.lines().collect(Collectors.joining());
                    LOG.info("Param saved, Response for param " + connection.getURL().toString() + " ", (Object)response);
                }
                catch (IOException e) {
                    String errorMessage = " - Failed to save param " + e.getMessage();
                    LOG.error(errorMessage, e);
                    throw new NetappInterfaceException(errorMessage);
                }
            }
            if (statusCode < 200 || statusCode > 299) {
                StringBuilder builder = new StringBuilder();
                builder.append("Server returned HTTP status ").append(statusCode).append(".");
                LOG.error(builder.toString());
                throw new NetappInterfaceException(builder.toString());
            }
        }
        catch (Exception exceptionInstance) {
            String errorMessage = " - Failed to save param" + exceptionInstance.getMessage();
            LOG.error(errorMessage, exceptionInstance);
            throw new NetappInterfaceException(errorMessage);
        }
    }
}

