/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import com.onaro.commons.util.ComparableComparator;
import com.onaro.commons.util.ValueConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class CollectionPrinter<E> {
    public static final String COMMA_SEPARATED = ", ";
    public static final CollectionPrinter<String> STRING = new CollectionPrinter();
    public static final CollectionPrinter<String> STRING_DISPLAY = new CollectionPrinter(", ");
    public static final CollectionPrinter<Long> LONG = CollectionPrinter.getComparableInstance(Long.class);
    public static final CollectionPrinter<Long> LONG_DISPLAY = CollectionPrinter.getComparableInstance(", ", null, Long.class);
    public static final CollectionPrinter<Integer> INTEGER = CollectionPrinter.getComparableInstance(Integer.class);
    public static final CollectionPrinter<Integer> INTEGER_DISPLAY = CollectionPrinter.getComparableInstance(", ", null, Integer.class);
    private String separator;
    private String blankValue;
    private String prefix;
    private String suffix;
    private Comparator<E> comparator;
    private int alignment;

    public CollectionPrinter(String separator, String blankValue, String prefix, String suffix, Comparator<E> comparator, int alignment) {
        assert (alignment == 10 || alignment == 11 || alignment == 2 || alignment == 0 || alignment == 4);
        this.separator = separator;
        this.blankValue = blankValue;
        this.prefix = prefix;
        this.suffix = suffix;
        this.comparator = comparator;
        this.setAlignment(alignment);
    }

    public CollectionPrinter(String separator, String blankValue, Comparator<E> comparator, int alignment) {
        this(separator, blankValue, null, null, comparator, alignment);
    }

    public CollectionPrinter(String separator, String blankValue, Comparator<E> comparator) {
        this(separator, blankValue, comparator, 10);
    }

    public CollectionPrinter(String separator, Comparator<E> comparator) {
        this(separator, null, comparator);
    }

    public CollectionPrinter(String separator) {
        this(separator, null);
        this.comparator = new DefaultComperator();
    }

    public CollectionPrinter() {
        this(",");
    }

    public static <C extends Comparable<C>> CollectionPrinter<C> getComparableInstance(Class<C> typeClass) {
        return CollectionPrinter.getComparableInstance(",", null, typeClass);
    }

    public static <C extends Comparable<C>> CollectionPrinter<C> getComparableInstance(String separator, String blankValue, Class<C> typeClass) {
        return Number.class.isAssignableFrom(typeClass) ? new CollectionPrinter<C>(separator, blankValue, ComparableComparator.getInstance(typeClass), 4) : new CollectionPrinter<C>(separator, blankValue, ComparableComparator.getInstance(typeClass), 10);
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getBlankValue() {
        return this.blankValue;
    }

    public void setBlankValue(String blankValue) {
        this.blankValue = blankValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setAlignment(int alignment) {
        assert (alignment == 10 || alignment == 11 || alignment == 2 || alignment == 0 || alignment == 4);
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String toString(E ... array) {
        return this.toString(Arrays.asList(array));
    }

    public String toString(Iterable<E> iterable) {
        if (iterable != null && iterable.iterator().hasNext()) {
            StringBuilder builder = new StringBuilder();
            boolean addedValue = false;
            Iterator<E> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                builder.append(this.separator);
                String s = this.text(iterator.next());
                if (s != null && s.trim().length() > 0) {
                    builder.append(s);
                    addedValue = true;
                    continue;
                }
                if (this.blankValue == null) continue;
                builder.append(this.blankValue);
            }
            if (!addedValue) {
                return "";
            }
            builder.delete(0, this.separator.length());
            if (this.prefix != null) {
                builder.insert(0, this.prefix);
            }
            if (this.suffix != null) {
                builder.append(this.suffix);
            }
            return builder.toString();
        }
        return "";
    }

    public String toString(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        if (collection.size() == 1 && this.prefix == null && this.suffix == null) {
            E element = collection.iterator().next();
            String text = this.text(element);
            if (text != null && text.trim().length() > 0) {
                return text;
            }
            if (this.blankValue != null) {
                return this.blankValue;
            }
            return "";
        }
        return this.toString(this.sort(collection));
    }

    public String toStringNoSort(Collection<E> collection) {
        return this.toString((Iterable<E>)collection);
    }

    private Iterable<E> sort(Collection<E> collection) {
        if (this.comparator != null && collection != null && collection.size() > 1) {
            ArrayList<E> list = new ArrayList<E>(collection);
            Collections.sort(list, this.comparator);
            return list;
        }
        return collection;
    }

    public String text(E value) {
        if (value == null) {
            return null;
        }
        if (ValueConstants.isNotAvailableValue(value)) {
            return "N/A";
        }
        return value.toString();
    }

    private class DefaultComperator
    implements Comparator<E> {
        private DefaultComperator() {
        }

        @Override
        public int compare(E o1, E o2) {
            String text1 = CollectionPrinter.this.text(o1);
            String text2 = CollectionPrinter.this.text(o2);
            if (text1 == null) {
                return text2 == null ? 0 : -1;
            }
            if (text2 == null) {
                return 1;
            }
            return text1.compareTo(text2);
        }
    }
}

