/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import com.onaro.commons.util.Message;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager {
    private static final MessageManager INSTANCE = new MessageManager();
    static final Logger logger = LoggerFactory.getLogger(MessageManager.class);

    public static MessageManager getInstance() {
        return INSTANCE;
    }

    protected MessageManager() {
    }

    public static <T> T getMessages(Class<? extends T> messagesClass) {
        Locale locale = Locale.getDefault();
        return MessageManager.getMessages(messagesClass, locale);
    }

    public static <T> T getMessages(Class<? extends T> messagesClass, Locale locale) {
        MessageManager messageManager = MessageManager.getInstance();
        return messageManager.getMessagesImpl(messagesClass, locale);
    }

    protected ResourceBundle getResourceBundle(Method method, Locale locale) {
        Class<?> clazz = method.getDeclaringClass();
        String rbBaseName = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        return ResourceBundle.getBundle(rbBaseName, locale, classLoader);
    }

    private final <T> T getMessagesImpl(Class<? extends T> messagesClass, Locale locale) {
        if (messagesClass == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader classLoader = messagesClass.getClassLoader();
        InvocationHandler invocationHandler = this.newInvocationHandler(locale);
        Class[] interfaces = new Class[]{messagesClass};
        Object proxyObj = Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        T proxy = messagesClass.cast(proxyObj);
        return proxy;
    }

    protected InvocationHandler newInvocationHandler(Locale locale) {
        return new MsgInvocationHandler(locale);
    }

    protected String getMessageKey(Method method) {
        Message message = method.getAnnotation(Message.class);
        if (message != null) {
            return this.getMessageKey(message);
        }
        String messageKey = method.getName();
        if (messageKey.startsWith("get")) {
            messageKey = messageKey.substring(3);
        }
        return messageKey;
    }

    protected final String getMessageKey(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        String msgKey = message.value();
        if (msgKey != null && msgKey.length() > 0) {
            return msgKey;
        }
        msgKey = message.key();
        if (msgKey == null || msgKey.trim().length() == 0) {
            throw new IllegalArgumentException("Message key not specified in annotation");
        }
        return msgKey;
    }

    protected boolean isFormat(Method method) {
        Message message = method.getAnnotation(Message.class);
        if (message == null) {
            return false;
        }
        return this.isFormat(message);
    }

    protected final boolean isFormat(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        return message.format();
    }

    protected String getMessage(Method method, Object[] args, Locale locale) {
        String msgKey = this.getMessageKey(method);
        boolean isFormat = this.isFormat(method);
        ResourceBundle rb = this.getResourceBundle(method, locale);
        String msgPattern = rb.getString(msgKey);
        String msg = null;
        msg = !isFormat && args != null && args.length > 0 ? MessageFormat.format(msgPattern, args) : msgPattern;
        return msg;
    }

    public void checkMessageAnnotations(Class<?> messagesClass) {
        for (Method method : messagesClass.getMethods()) {
            this.getMessageKey(method);
        }
    }

    public void checkMissingMessages(Class<?> messagesClass) {
        this.checkMissingMessages(messagesClass, Locale.getDefault());
    }

    public void checkMissingMessages(Class<?> messagesClass, Locale locale) {
        for (Method method : messagesClass.getMethods()) {
            String msgKey = this.getMessageKey(method);
            ResourceBundle rb = this.getResourceBundle(method, locale);
            rb.getString(msgKey);
        }
    }

    public void checkUnusedMessages(Class<?> messagesClass) {
        this.checkUnusedMessages(messagesClass, Locale.getDefault());
    }

    public void checkUnusedMessages(Class<?> messagesClass, Locale locale) {
        String rbBaseName = messagesClass.getName();
        ClassLoader classLoader = messagesClass.getClassLoader();
        ResourceBundle rb = ResourceBundle.getBundle(rbBaseName, locale, classLoader);
        Enumeration<String> keyEnumeration = rb.getKeys();
        HashSet<String> unusedKeys = new HashSet<String>();
        while (keyEnumeration.hasMoreElements()) {
            String string = keyEnumeration.nextElement();
            unusedKeys.add(string);
        }
        for (Method method : messagesClass.getMethods()) {
            String msgKey = this.getMessageKey(method);
            unusedKeys.remove(msgKey);
        }
        if (!unusedKeys.isEmpty()) {
            String string = "Resource bundle for message class {0} has the following unused keys: {1}";
            throw new IllegalArgumentException(MessageFormat.format(string, messagesClass.getName(), ((Object)unusedKeys).toString()));
        }
    }

    public void checkMalformedParameters(Class<?> messagesClass) {
        this.checkMalformedParameters(messagesClass, Locale.getDefault());
    }

    public void checkMalformedParameters(Class<?> messagesClass, Locale locale) {
        for (Method method : messagesClass.getMethods()) {
            String msg;
            String msgKey = this.getMessageKey(method);
            boolean isFormat = this.isFormat(method);
            ResourceBundle rb = this.getResourceBundle(method, locale);
            String msgPattern = rb.getString(msgKey);
            int numMethodParams = method.getParameterTypes().length;
            Pattern pattern = Pattern.compile("\\{(\\d+).*?\\}");
            Matcher matcher = pattern.matcher(msgPattern);
            int groupCount = 0;
            int maxPattern = 0;
            while (matcher.find()) {
                ++groupCount;
                String group = matcher.group(1);
                Integer value = Integer.valueOf(group);
                if (value <= maxPattern) continue;
                maxPattern = value;
            }
            if (isFormat) {
                if (numMethodParams == 0) continue;
                msg = "Message method specifies parameters but method is declared as a format {0}";
                throw new IllegalArgumentException(MessageFormat.format(msg, method.getName()));
            }
            if (numMethodParams != 0 && groupCount == 0) {
                msg = "Message method does not specify parameters for method {0} pattern {1}";
                throw new IllegalArgumentException(MessageFormat.format(msg, method.getName(), msgPattern));
            }
            if (groupCount == 0 && numMethodParams != 0) {
                msg = "Message method specifies parameters that are not used by pattern for method {0} pattern {1}";
                throw new IllegalArgumentException(MessageFormat.format(msg, method.getName(), msgPattern));
            }
            if (groupCount <= 0 || numMethodParams == maxPattern + 1) continue;
            msg = "Incorrect number of method arguments, {0} != {1} for method {2} pattern {3}";
            throw new IllegalArgumentException(MessageFormat.format(msg, numMethodParams, maxPattern + 1, method.getName(), msgPattern));
        }
    }

    protected static class MsgInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final Locale locale;

        public MsgInvocationHandler(Locale locale) {
            if (locale == null) {
                throw new IllegalArgumentException();
            }
            this.locale = locale;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String msg = MessageManager.getInstance().getMessage(method, args, this.locale);
            return msg;
        }
    }
}

