/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

public enum Unit {
    BYTE,
    KILOBYTE(BYTE, Unit.BYTE.conversionFactor * 1024L),
    MEGABYTE(BYTE, Unit.KILOBYTE.conversionFactor * 1024L),
    GIGABYTE(BYTE, Unit.MEGABYTE.conversionFactor * 1024L),
    TERABYTE(BYTE, Unit.GIGABYTE.conversionFactor * 1024L),
    MILLISECOND,
    SECOND(MILLISECOND, Unit.MILLISECOND.conversionFactor * 1000L),
    MINUTE(MILLISECOND, Unit.SECOND.conversionFactor * 60L),
    HOUR(MILLISECOND, Unit.MINUTE.conversionFactor * 60L),
    DAY(MILLISECOND, Unit.HOUR.conversionFactor * 24L),
    WEEK(MILLISECOND, Unit.DAY.conversionFactor * 7L),
    MONTH(MILLISECOND, Unit.DAY.conversionFactor * 31L),
    QUARTER(MILLISECOND, Unit.MONTH.conversionFactor * 3L),
    YEAR(MILLISECOND, Unit.DAY.conversionFactor * 365L);

    private final Unit baseUnit;
    private final long conversionFactor;

    private Unit() {
        this(null, 1L);
    }

    private Unit(Unit baseUnit, long conversionFactor) {
        this.baseUnit = baseUnit;
        this.conversionFactor = conversionFactor;
    }

    public static long convert(long quantity, Unit sourceUnit, Unit targetUnit) {
        return sourceUnit.convertTo(quantity, targetUnit);
    }

    public static double convert(double quantity, Unit sourceUnit, Unit targetUnit) {
        return sourceUnit.convertTo(quantity, targetUnit);
    }

    public boolean canConvertTo(Unit target) {
        if (this == target) {
            return true;
        }
        return target != null && (this.baseUnit != null || target.baseUnit == this) && (target.baseUnit != null || this.baseUnit == target);
    }

    public double convertTo(double quantity, Unit target) {
        if (!this.canConvertTo(target)) {
            throw new IllegalArgumentException("Incompatible units for conversion");
        }
        if (this == target) {
            return quantity;
        }
        if (this.conversionFactor > target.conversionFactor) {
            double conversionRatio = this.conversionFactor / target.conversionFactor;
            return quantity * conversionRatio;
        }
        double conversionRatio = target.conversionFactor / this.conversionFactor;
        return quantity / conversionRatio;
    }

    public long convertTo(long quantity, Unit target) {
        if (!this.canConvertTo(target)) {
            throw new IllegalArgumentException("Incompatible units for conversion");
        }
        if (this == target) {
            return quantity;
        }
        if (this.conversionFactor > target.conversionFactor) {
            double conversionRatio = this.conversionFactor / target.conversionFactor;
            return Math.round((double)quantity * conversionRatio);
        }
        double conversionRatio = target.conversionFactor / this.conversionFactor;
        return Math.round((double)quantity / conversionRatio);
    }

    public Double convertTo(Number quantity, Unit target) {
        return this.convertTo(quantity.doubleValue(), target);
    }
}

