/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static int CHUNK = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toGz(String fileName, String gzFileName) throws IOException {
        DeflaterOutputStream zipOut = null;
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            int length;
            out = new BufferedOutputStream(new FileOutputStream(gzFileName));
            zipOut = new GZIPOutputStream(out);
            byte[] buffer = new byte[CHUNK];
            in = new BufferedInputStream(new FileInputStream(fileName));
            while ((length = in.read(buffer, 0, CHUNK)) != -1) {
                ((GZIPOutputStream)zipOut).write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (zipOut != null) {
                zipOut.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromGz(String gzFileName, String fileName) throws IOException {
        OutputStream out = null;
        BufferedInputStream in = null;
        GZIPInputStream zipIn = null;
        try {
            int length;
            in = new BufferedInputStream(new FileInputStream(gzFileName));
            zipIn = new GZIPInputStream(in);
            byte[] buffer = new byte[CHUNK];
            out = new BufferedOutputStream(new FileOutputStream(fileName));
            while ((length = zipIn.read(buffer, 0, CHUNK)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (zipIn != null) {
                zipIn.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toZip(String[] fileNames, ByteArrayOutputStream[] streamArray, OutputStream outputStream) throws IOException {
        try (ZipOutputStream zipOut = null;){
            zipOut = new ZipOutputStream(outputStream);
            zipOut.setMethod(8);
            for (int i = 0; i < fileNames.length; ++i) {
                CRC32 crc = new CRC32();
                crc.reset();
                ByteArrayOutputStream byteArrayOutputStream = streamArray[i];
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                crc.update(byteArray);
                String fileName = fileNames[i];
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipEntry.setCrc(crc.getValue());
                zipEntry.setSize(byteArrayOutputStream.size());
                zipOut.putNextEntry(zipEntry);
                zipOut.write(byteArray);
                zipOut.closeEntry();
            }
        }
    }

    public static void toZip(String[] fileNames, String zipFileName) throws IOException {
        Zip.toZip(fileNames, new FileOutputStream(zipFileName), true, "");
    }

    public static void toZip(String[] fileNames, OutputStream outputStream, boolean flatDir) throws IOException {
        Zip.toZip(fileNames, outputStream, flatDir, "");
    }

    public static void toZip(String[] fileNames, OutputStream outputStream, String relativeDir) throws IOException {
        Zip.toZip(fileNames, outputStream, false, relativeDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toZip(String[] fileNames, OutputStream outputStream, boolean flatDir, String relativeDir) throws IOException {
        ZipOutputStream zipOut = null;
        InputStream fileInputStream = null;
        try {
            zipOut = new ZipOutputStream(outputStream);
            zipOut.setMethod(8);
            byte[] buffer = new byte[CHUNK];
            for (String fileName : fileNames) {
                int length;
                File file = new File(fileName);
                if (!file.exists()) continue;
                fileInputStream = new BufferedInputStream(new FileInputStream(file));
                CRC32 crc = new CRC32();
                crc.reset();
                while ((length = fileInputStream.read(buffer)) != -1) {
                    crc.update(buffer, 0, length);
                }
                fileInputStream.close();
                fileInputStream = null;
                if (flatDir) {
                    int idx = fileName.lastIndexOf(47);
                    if (idx == -1) {
                        idx = fileName.lastIndexOf(92);
                    }
                    if (idx > -1) {
                        fileName = fileName.substring(idx, fileName.length());
                    }
                } else if (relativeDir.length() > 0 && fileName.indexOf(relativeDir) == 0) {
                    fileName = fileName.substring(relativeDir.length());
                }
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipEntry.setCrc(crc.getValue());
                zipEntry.setSize(file.length());
                zipEntry.setTime(file.lastModified());
                zipOut.putNextEntry(zipEntry);
                fileInputStream = new BufferedInputStream(new FileInputStream(file));
                while ((length = fileInputStream.read(buffer)) > -1) {
                    zipOut.write(buffer, 0, length);
                }
                fileInputStream.close();
                zipOut.closeEntry();
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (zipOut != null) {
                zipOut.close();
            }
        }
    }

    public static void fromZip(String zipFileName, File dir) throws IOException {
        Zip.fromZip(new BufferedInputStream(new FileInputStream(zipFileName)), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromZip(InputStream inputStream, File dir) throws IOException {
        ZipInputStream zipIn = null;
        OutputStream bufferedOutputStream = null;
        try {
            ZipEntry entry;
            if (!dir.exists()) {
                dir.mkdir();
            }
            zipIn = new ZipInputStream(inputStream);
            while ((entry = zipIn.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[CHUNK];
                File outputFile = new File(dir.getPath() + "\\" + entry.getName());
                outputFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(outputFile);
                bufferedOutputStream = new BufferedOutputStream(fos, CHUNK);
                while ((count = zipIn.read(data, 0, CHUNK)) != -1) {
                    bufferedOutputStream.write(data, 0, count);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                fos.close();
            }
            zipIn.close();
        }
        finally {
            if (zipIn != null) {
                zipIn.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] compressed) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(compressed);
        ZipInputStream zin = new ZipInputStream(in);
        try {
            int offset;
            zin.getNextEntry();
            byte[] buffer = new byte[1024];
            while ((offset = zin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
        }
        finally {
            out.close();
            zin.close();
        }
        return out.toByteArray();
    }

    public static byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            zout.putNextEntry(new ZipEntry("0"));
            zout.write(bytes);
            zout.closeEntry();
        }
        return out.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        Zip.toZip(new String[]{"c:\\TEMP\\XXX\\New_Sym_Test3_oData.xml", "c:\\TEMP\\XXX\\Sym_Test3_oData.xml"}, "c:\\TEMP\\XXX\\test.zip");
        Zip.fromZip("c:\\TEMP\\XXX\\test.zip", new File("c:\\TEMP\\XXX\\ddd2"));
    }
}

